<?php

namespace Diamond\Presentation\Modules\AdminStatBans;

use ActiveTable\ColumnTable;
use ActiveTable\DataTableEngine;
use Core\Form\Control\Menu;
use Core\Form\ControlBuilder;
use Core\Helpers\Date;
use Core\ModuleController;
use Diamond\Domain\StatBan\Contracts\StatBanEntityInterface;
use Diamond\Domain\StatRule\Contracts\StatRuleEntityInterface;
use Diamond\Helpers\Form;
use Diamond\Infrastructure\Models\StatBan\StatBan;
use Diamond\Repositories\StatBan\StatBanCriteria;
use Diamond\Repositories\StatBan\StatBanRepository;
use Diamond\Repositories\StatRule\StatRuleCriteria;
use Diamond\Repositories\StatRule\StatRuleRepository;
use DiamondTable\CommandFactory;
use DiamondTable\TableFactory;

/**
 * Description of AdminStatBans
 *
 * @author Diamond Code Generator
 */
class AdminStatBans extends ModuleController
{


    private $statBanRepository;
    private $tableFactory;
    private $controlBuilder;

    public function __construct(StatBanRepository $statBanRepository,
                                TableFactory      $tableFactory, ControlBuilder $builder)
    {
        $this->statBanRepository = $statBanRepository;
        $this->tableFactory = $tableFactory;
        $this->controlBuilder = $builder;
    }

    /**
     * @return string
     */
    public function process(): string
    {
        $table = $this->tableFactory->buildAdminTable($this->statBanRepository, StatBanCriteria::create());

        $table
            ->removeControlAccess(DataTableEngine::CONTROL_ACCESS_ADD)
            ->removeControlAccess(DataTableEngine::CONTROL_ACCESS_EDIT)
            ->setDefaultSortColumn('id', 'DESC')
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
                    ->setSorted(true)
            )
            ->addColumn(
                (new ColumnTable('CreatedAt', 'Дата добавления'))
                    ->setFormat($this, 'formatDateTime')
            )
            ->addColumn(
                (new ColumnTable('Period', 'Период'))
            )
            ->addColumn(
                (new ColumnTable('Period', 'Период'))
            )
            ->addColumn(
                (new ColumnTable('Rule', 'Правило'))
            )
            ->addColumn(
                (new ColumnTable('UriMask', 'Url страница'))
            )
            ->addColumn(
                (new ColumnTable('AgentMask', 'Браузер/агент'))
            )
            ->addColumn(
                (new ColumnTable('HostName', 'Хост'))
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setWidth(120)
                    ->setFormat($this, 'formatActions')
            );
        return $table->render();
    }

    /**
     * @param StatBan $ban
     * @return string
     */
    public function formatDateTime(StatBanEntityInterface $ban): string
    {
        return $ban->getCreatedAt()->format(Date::formatDisplay());
    }

    public function formatActions(StatBanEntityInterface $userEntity): string
    {
        return (new Menu(
            [
                anchor('javascript:void(0);', Form::buildIconText('trash_white', 'Удалить'), [
                    'onclick' => "action_row({$userEntity->getId()},'" . CommandFactory::ROWS_DELETE . "','Действительно удалить запись?')"
                ])
            ], 'Действие'))->render();
    }
}               