<?php

namespace Diamond\Modules\AdminMailMaster;

use  Core\Template\Template;
use Core\Form\ControlBuilder;
use Diamond\Repositories\MailingSubscriber;
use Diamond\Repositories\MailingTemplate;
use Diamond\Helpers\Form;

/**
 * Description of AdminSyncMySklad
 *
 * @author Diamond Code Generator
 */
class AdminMailMaster extends \Core\ModuleController
{

    protected $template;
    protected $control;
    protected $subscriberRepo;
    protected $templateRepo;

    public function __construct(Template $template,
                                ControlBuilder $control,
                                MailingSubscriber $subscriberRepo,
                                MailingTemplate $templateRepo)
    {
        $this->template = $template;
        $this->control = $control;
        $this->subscriberRepo = $subscriberRepo;
        $this->templateRepo = $templateRepo;
    }

    public function process(): string
    {
        //$this->template->addScriptLinks(array(
        //    '/_diamond/widgets/assets/jquery/wizard/smartWizard-2.0.min.js',
        //    '/_diamond/widgets/assets/jquery/form/jquery.form.min.js'
        //));

        $this->template->addScriptLinks(array(
            '/_diamond/diamond-cms/assets/nifty/plugins/bootstrap-wizard/jquery.bootstrap.wizard.min.js',
            '/_diamond/diamond-cms/assets/nifty/plugins/bootstrap-validator/bootstrapValidator.min.js',

        ));


    $this->template->addScriptLinks($this->getJsLinks());
        $this->template->addStyleLinks($this->getCssLinks());
        $this->template->addScript($this->render('javascript'));

        $templates = Form::prepareDropdown($this->templateRepo, 'шаблон письма');
        $subscribers = Form::prepareDropdown($this->subscriberRepo, 'список рассылки');

        $templatesDropdown
            = $this
            ->control
            ->buildDropdownUniform('template', $templates)
            ->onChange('previewTemplate(this)')
            ->setClass('required');

        $subscriberDropdown
            = $this
            ->control
            ->buildDropdownUniform('subscriber', $subscribers)
            ->onChange('previewSubscriber(this)')
            ->setClass('required');

        $periodDropdown
            = $this
            ->control
            ->buildDropdownUniform('period', [
                'one' => 'разовое выполнение',
                '60' => 'каждые 1 час',
                '240' => 'каждые 4 часа',
                '480' => 'каждые 8 часов',
                '720' => 'каждые 12 часов',
                '1440' => 'каждые день',
                '10080' => 'каждую неделю'
            ]);

        $options = ['-1' => 'сразу'];

        for ($h = 0; $h <= 23; $h++) {

            for ($m = 0; $m <= 45; $m = $m + 15) {
                $l = ($h < 10 ? '0' . $h : $h) . ':' . ($m < 10 ? '0' . $m : $m);

                $options[$l] = $l;
            }
        }


        $timeDropdown
            = $this
            ->control
            ->buildDropdownUniform("time", $options);


        //dump($templatesDropdown,$subscriberDropdown);

        return $this->render([
            'selected' => 1,
            'steps' => [
                [
                    'id' => 1,
                    'title' => 'Шаг 1',
                    'desc' => 'Выбор шаблона',
                    'content' => $this->render('step1', [
                        'templatesDropdown' => $templatesDropdown->render()
                    ])
                ],
                [
                    'id' => 2,
                    'title' => 'Шаг 2',
                    'desc' => 'Выбор получателей',
                    'content' => $this->render('step2', [
                        'subscriberDropdown' => $subscriberDropdown->render()
                    ])
                ],
                [
                    'id' => 3,
                    'title' => 'Шаг 3',
                    'desc' => 'Настройка рассылки',
                    'content' => $this->render('step3', [
                        'periodDropdown' => $periodDropdown->render(),
                        'timeDropdown' => $timeDropdown->render()
                    ])
                ],
                [
                    'id' => 4,
                    'title' => 'Шаг 4',
                    'desc' => 'Предварительный просмотр',
                    'content' => $this->render('step4')
                ]
            ]
        ]);
    }

    /**
     * @return array
     */
    private function getCssLinks(): array
    {
        return array(
            //'/_diamond/widgets/assets/jquery/jgrid/skin/ui.jqgrid.css',
            // '/_diamond/diamond-cms/assets/css/plugins/jqgrid.style.css'
        );
    }

    /**
     * @return array
     */
    private function getJsLinks(): array
    {
        return array(
         //   '/_diamond/widgets/assets/jquery/lib/jquery-1.7.2.min.js',
            // '/_diamond/widgets/assets/jquery/jgrid/grid-locale-ru.js',
            // '/_diamond/widgets/assets/jquery/jgrid/jquery-jqGrid-min.js'
        );
    }

}