<?php

namespace Diamond\Modules\AdminLogsAnalize;

use ActiveTable\DataTableEngine;
use Core\Form\Control\Button;
use Core\Form\Control\MenuItemEdit;
use Core\Form\ControlBuilder;
use Core\Helpers\File;
use Core\Helpers\Date;
use Diamond\Repositories\ErrorLog\ErrorLog;
use Diamond\Repositories\ErrorLog\ErrorLogCriteria;
use Diamond\Repositories\ErrorLog\ErrorLogEntity;
use DiamondTable\TableFactory;
use ActiveTable\ColumnTable;


/**
 * Class AdminLogsAnalize
 * @package Diamond\Modules\AdminLogsAnalize
 */
class AdminLogsAnalize extends \Core\ModuleController
{


    public function __construct(private ErrorLog $repo, private TableFactory $tableFactory, private ControlBuilder $controlBuilder)
    {}


    public function process(): string
    {

        $file = input_get('file');

        if ($file) {
            return $this->viewFile($file);
        }

        $table = $this->tableFactory->buildAdminTable($this->repo, ErrorLogCriteria::create());

        //create table
        $table
            ->addColumn(
                (new ColumnTable('filename', 'Лог-файл'))->setWidth(50, true)->setFormat($this, 'formatFileName')
            )
            ->addColumn(
                (new ColumnTable('date', 'Дата создания'))->setFormat($this, 'formatDateTime')
            )
            ->addColumn(
                (new ColumnTable('size', 'Размер'))->setFormat($this, 'formatSize')
            )
            ->addColumn(
                (new ColumnTable('errors', 'Ошибок'))
            )
            ->addColumn(
                (new ColumnTable('actions', ''))->setWidth(15, true)->setFormat($this, 'formatActions')
            )
            ->removeControlAccess(DataTableEngine::CONTROL_ACCESS_ADD)
            ->removeControlAccess(DataTableEngine::CONTROL_ROWS_ACTION)
            ->removeControlAccess(DataTableEngine::CONTROL_ACCESS_DELETE);


        return $table->render();
    }


    public function formatActions(ErrorLogEntity $logEntity): string
    {
        return $this->controlBuilder->buildActionMenu([
            (new MenuItemEdit(1,adaptive_url(['file' => $logEntity->getFileName()])))->setClassIcon('demo-pli-magnifi-glass')
        ])->render();
    }


    protected function viewFile(string $fileOtput): string
    {

        $files = $this->repo->findByCriteria(
            ErrorLogCriteria::create()->setFilterByFileName($fileOtput)
        );

        if (!$file = $files->current()) {
            return '';
        }

        return $this->render([
            'file' => $file->getFIleName(),
            'content' => file_get_contents($file->getPathname()),
            'back' => (new Button('back', '<< Вернуться назад'))
                ->setClass('btn btn-warning mar-btm')
                ->setOnClick('location.href=\''.admin_path('/diamond/system/logs').'\'')
                ->render()
        ]);
    }


    public function formatFileName(ErrorLogEntity $logEntity): string
    {

        return
            $logEntity->getFileName();
    }


    public function formatDateTime(ErrorLogEntity $logEntity): string
    {
        return $logEntity->getDate() ? $logEntity->getDate()->format(Date::formatDisplay()) : '';
    }


    public function formatSize(ErrorLogEntity $logEntity): string
    {
        return File::formatSizeUnits($logEntity->getSize());
    }


}               