<?php

namespace Diamond\Helpers;

class SystemHelper
{

    /**
     * Преведение к Гб
     * @param array $data
     * @return float[]
     */
    public static function prepareData(array $data):array
    {
        $db_size = self::prepareParam($data['DB_SIZE']??'');
        $site_size = self::prepareParam($data['SITE_SIZE']??'');
        $post_size = self::prepareParam($data['POST_SIZE']??'');
        $size_kh = self::prepareParam($data['KH_SIZE']??'');

        $all = self::prepareParam($data['DISK_LIMIT']??'');
        $free = self::prepareParam($data['DISK_FREE']??'');


        if(!isset($data['DISK_FREE'])){
            $use = $db_size + $site_size + $post_size + $size_kh;
            $free =  $all - $use;
        }

        return [
            'DB_SIZE' => $db_size,
            'SITE_SIZE' => $site_size,
            'POST_SIZE' => $post_size,
            'DISK_LIMIT' => $all,
            'DISK_FREE' => $free,
            'KH_SIZE' => $size_kh
        ];
    }

    private static function prepareParam(string $param): float
    {

        $param = str_replace(',','.',$param);
        $param2 = (float)$param;

        if(str_contains($param, 'M')){
            $param2 = round((float)$param2 / 1024,2);
        }
        elseif(str_contains($param, 'K')){
            $param2 = round($param2 / 1024 / 1024,2);
        }
        elseif(str_contains($param, 'T')){
            $param2 = round($param2 * 1024,2);
        }

        return $param2;
    }

}