<?php

namespace Diamond\Helpers;

use Core\Form\Simpleform;
use Diamond\Factory\ServerRequest;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;

/**
 * Description of Form
 *
 * @author Admin
 */
class Form
{

    /**
     * получвает id из POST данных
     * @param array|null $postData
     * @return array
     */
    public static function getIdsFromRequest(?array $postData = null): array
    {
        if (!$postData) {
            $postData = ServerRequest::build(Request::createFromGlobals())->getParsedBody();
        }


        $ids = isset($postData['ids']) ? explode(',', trim($postData['ids'], ',')) : [];

        $ids = array_filter($ids, function ($v) {
            return $v > 0;
        });
        return $ids;
    }

    public static function addTableNotice(string $notice): void
    {
        $session = new Session();
        $session->getFlashBag()->add('table-notice', $notice);
    }


    /**
     * @param string $text
     * @param string $caption
     * @return string
     */
    public static function buildAnnouncementMessage(string $text, string $caption = 'Внимание!')
    {
        return (new Simpleform(md5(rand(1, 10))))->createMessage($text, 'warning');
    }


    /**
     * @param string $text
     * @return string
     */
    public static function buildSuccessMessage(string $text): string
    {
        return (new Simpleform(md5(rand(1, 10))))->createMessage($text, Simpleform::MESSAGE_SUCCESS);
    }

    /**
     * @param string $text
     * @return string
     * @deprecated
     * @see Form::buildErrorMessage()
     */
    public static function buildSuccessAlert(string $text): string
    {
        return self::buildErrorMessage($text);
    }

    /**
     * @param string $text
     * @return string
     */
    public static function buildErrorMessage(string $text): string
    {
        return (new Simpleform(md5(rand(1, 10))))->createMessage($text, Simpleform::MESSAGE_ERROR);
    }

    /**
     * @param string $text
     * @return string
     * @deprecated
     * @see Form::buildInfoMessage()
     */
    public static function buildSuccessInfo(string $text): string
    {
        return self::buildInfoMessage($text);
    }

    /**
     * @param string $text
     * @return string
     */
    public static function buildInfoMessage(string $text): string
    {
        return (new Simpleform(md5(rand(1, 10))))->createMessage($text, Simpleform::MESSAGE_ERROR);
    }

    /**
     * Ссылка вернутся назад
     * @param string $text
     * @return string
     */
    public static function buildBackAnchor($text = 'Вернуться назад'): string
    {
        return anchor(current_url(), $text, [
            'class' => 'alert-link'
        ]);
    }

    /**
     * @param \Core\Repository\DropDownInterface $repo
     * @param string $name
     * @param string $fn
     * @return array
     */
    public static function prepareDropdown(\Core\Repository\DropDownInterface $repo, $name = 'элемент',
                                           $fn = 'getDropdownList'): array
    {
        $ar[''] = sprintf('- выберите %s -', $name);
                return self::prepareDropdownWithoutDef($repo, $ar, $fn);
    }

    public static function prepareDropdownWithoutDef(\Core\Repository\DropDownInterface $repo,  $ar = [], $fn = 'getDropdownList'): array
    {

        foreach ((array)$repo->$fn() as $k => $v) {
            $ar[$k] = $v;
        }
        return $ar;
    }

    /**
     * выбор с уазанием дефолтного нулевого значения
     * @param \Core\Repository\DropDownInterface $repo
     * @param string $def
     * @param string $name
     * @param string $fn
     * @return mixed
     */
    public static function prepareDropdownWithDef(\Core\Repository\DropDownInterface $repo, $def = '',
                                                  $name = 'элемент', $fn = 'getDropdownList')
    {
        $ar[$def] = sprintf('- %s -', $name);
        foreach ((array)$repo->$fn() as $k => $v) {
            $ar[$k] = $v;
        }
        return $ar;
    }

    /**
     * Иконки
     * @param string $name
     * @param string $title
     * @param string $package
     * @return string
     */
    public static function buildIcon(string $name, string $title = '', string $package = 'diamond-cms'): string
    {
        return '<img src="/_diamond/' . $package . '/assets/images/icons/' . $name . '.png" title="' . $title . '" />';
    }

    /**
     * @param string $name
     * @param string $title
     * @param string $class
     * @return string
     */
    public static function buildSpriteIcon(string $name, string $title = '', string $class = '', string $help = ''): string
    {
        return sprintf('<i %s class="sprite %s %s interval10right"></i> %s', ($help?'title="'.$help.'"':''), $class, $name, $title);
    }


    /**
     * Иконк + текст после
     * @param string $name
     * @param string $text
     * @param string $title
     * @param string $package
     * @return string
     */
    public static function buildIconText(string $name, string $text, string $title = '', string $package = 'diamond-cms'): string
    {
        return sprintf(
            '<span>%s</span>' . nbs(1) . '<span>%s</span>',
            self::buildIcon($name, $title, $package),
            $text
        );
    }

    /**
     * всплывалка с текстом
     * @param string $html
     * @param string $caption
     * @return string
     */
    public static function buildPopUp(string $html, string $caption): string
    {
        $onclick
            = "jQuery.alerts._show('" . $caption . "','" . $html . "',null,'alert')";

        return '<a href="javascript:void(0)" onclick="' . $onclick . '">' . $caption . '</a>';
//        return '<a href="javascript:void(0)" onclick="' .
//            "jQuery.alerts._show('" . $caption . "','" . $html . "',null,'alert')"
//            . '">' . $caption . '</a>';
    }
}