<?php

namespace Diamond\Factory;

use Core\Form\Control as ControlForm;
use Core\Registry\Control;
use Core\Registry\Factory\RepoRegistry;
use Core\Registry\Field;
use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\PaginationInterface;

/**
 * фАБРИКА ТАБЛИЦ
 * @deprecated
 * @author Admin
 */
class Table #implements \Shop\Contracts\ShopCurrentInterface
{

    protected $repoRegistry;
    protected $cBuilder;
    protected $domainRepo;
    //use \Shop\Concrete\ShopAuthUserTrait;

    //закоментированно так как не используется
//    function __construct(RepoRegistry $repoRegistry, \Core\Form\ControlBuilder $cBuilder,
//                         \Diamond\Repositories\Domain $domainRepo)
//    {
//        $this->repoRegistry = $repoRegistry;
//        $this->cBuilder = $cBuilder;
//        $this->domainRepo = $domainRepo;
//    }

    /**
     * @param string $name
     * @param CrudRepositoryBuilderInterface $orderRepo
     * @param PaginationInterface $criteria
     * @return \Core\Table\PropelDataTable
     */
    public function buildSimpleRepoTable(string $name,
                                         PropelAbstractRepository $orderRepo,
                                         PaginationInterface $criteria)
    {
        $class = "table table-sm table-striped table-prices";
        return (new \Core\Table\PropelDataTable($orderRepo,$criteria))->setClass($class);
    }

    /**
     * @deprecated
     * @see DiamondTable
     * @param string $name
     * @param \Core\Repository\PropelQueryAbstract $repo
     * @return \Core\Registry\RepoRegisry
     */
    public function buildAdminTable(string $name, \Core\Repository\PropelQueryAbstract $repo): \Core\Registry\RepoRegisry
    {
        $registry = $this->repoRegistry->build($repo, $name);
        $registry->addControl((new Control\ButtonAdd("Добавить"))->setName("button_add")->setType("button"));
        $registry->addControl((new Control\ButtonEdit("Редактировать"))->setName("button_edit")->setType("button"));
        $registry->addControl((new Control\ButtonDelete("Удалить"))->setName("button_del")->setType("button"));
        $registry->addField(new Field(new ControlForm\Submit("submit", "Сохранить")));
        $registry->addField(new Field($this->cBuilder->buildCancel("back", "Вернуться назад")));
        return $registry;
    }

    /**
     * @deprecated
     * @see DiamondTable
     * @param \Core\Registry\RepoRegisry $table
     * @return \Core\Registry\RepoRegisry
     */
    public function prepareAdminForm(\Core\Registry\RepoRegisry $table): \Core\Registry\RepoRegisry
    {
        $builder = $this->cBuilder;
        $domainRepo = $this->domainRepo;

        $domains = \Diamond\Helpers\Form::prepareDropdown($domainRepo);

        /**
         * @todo Реализовать работу с поддоменами на уровне новых CRUD репозиторий и критерий выборки
         */
        #$id = is_a($this->curShop,ActiveRecordInterface::class) ? $this->curShop->getId() : 0;
        $this->curShop = null;
        if (is_a($this->curShop,ActiveRecordInterface::class) && $this->curShop->getType() === "dealer") {
            $table->addField(new Field($builder->buildHidden("domainId")->setValue($this->curShop->getDomainId())));

        } else {
            $table->addField(new Field(
                $builder
                    ->buildDropdownUniform("domainId", $domains
                    ), "Субдомен", "required", "для мультисайта"
            ));
        }

        return $table;
    }

}