<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 05.09.2020
 * Time: 22:20
 */

namespace Diamond\Repositories\SliderImage;


use Diamond\Domain\SliderImage\SliderImageCollection;
use Diamond\Infrastructure\Models\ImageSlider\ImageSlider;
use Diamond\Infrastructure\Models\ImageSlider\ImageSliderQuery;
use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;

class SliderImageRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    /**
     * @return EntityInterface
     */
    public static function createEntity(): EntityInterface
    {
        return new ImageSlider();
    }

    /**
     * @return ModelCriteria
     */
    protected function createQuery(): ModelCriteria
    {
        return ImageSliderQuery::create();
    }


    /**
     * @param PaginationInterface|SliderImageCriteria $criteria
     * @param ModelCriteria|ImageSliderQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $dbCriteria
            ->_if($criteria->getFilterByActive()!==null)
            ->filterByActive($criteria->getFilterByActive()===true?1:0)
            ->_endif()
->_if($criteria->getFilterByCode() !== null)
            ->filterByCode($criteria->getFilterByCode())
            ->_endif()
            ;
    }

    protected function createCollection(): CollectionInterface
    {
        return new SliderImageCollection();
    }
    
}