<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 26.08.2020
 * Time: 14:59
 */

namespace Diamond\Repositories\Site;

use Diamond\Domain\Site\Contracts\SiteCriteriaInterface;
use Diamond\Domain\Site\Contracts\StatCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class SiteCriteria extends AbstractCriteria implements SiteCriteriaInterface
{

    /**
     * @var string|null
     */
    protected $searchByHost;

    /**
     * @var string|null
     */
    protected $searchByName;

    /**
     * @var string|null
     */
    protected $sortByHost;

    public static function create()
    {
        return new self;
    }

    /**
     * @return string|null
     */
    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param string|null $searchByName
     * @return SiteCriteria
     */
    public function setSearchByName(?string $searchByName): SiteCriteriaInterface
    {
        $this->searchByName = $searchByName;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getSearchByHost(): ?string
    {
        return $this->searchByHost;
    }

    /**
     * @param string|null $searchByHost
     * @return SiteCriteria
     */
    public function setSearchByHost(?string $searchByHost): SiteCriteriaInterface
    {
        $this->searchByHost = $searchByHost;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSortByHost(): ?string
    {
        return $this->sortByHost;
    }

    /**
     * @param string|null $sort
     * @return $this
     */
    public function setSortByHost(?string $sort): SiteCriteriaInterface
    {
        $this->sortByHost = $sort;
        return $this;
    }
}