<?php

namespace Diamond\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Diamond\Infrastructure\Models\Report\Report as ReportEntity;
use \Diamond\Infrastructure\Models\Report\ReportQuery;

/**
 * Description of Page
 *
 * @author Admin
 */
class Report extends PropelQueryAbstract implements CrudInterface{
    
    public function buildEntity() {
        return new ReportEntity();
    }

    public function buildQuery() {
        return ReportQuery::create();
    }
    
    /**
     * 
     * @param type $code
     * @return ReportEntity
     */
    public function findByCode($code) {
        return $this->buildQuery()
                ->findOneByCode($code);
    }
}