<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 26.08.2020
 * Time: 11:24
 */

namespace Diamond\Repositories\Page;


use Diamond\Domain\Page\Contracts\PageCriteriaInterface;
use Diamond\Domain\Page\Contracts\PageEntityInterface;
use Diamond\Domain\Page\PageCollection;
use Diamond\Domain\Page\ReportCollection;
use Diamond\Infrastructure\Models\Page\Page;
use Diamond\Infrastructure\Models\Page\PageQuery;
use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;

class PageRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{

    public static function createEntity(): EntityInterface
    {
        return new Page();
    }

    protected function createQuery(): ModelCriteria
    {
        return PageQuery::create();
    }

    /**
     * @param EntityInterface|Page $entity
     * @return void
     */
    public function save(EntityInterface $entity): void
    {
       if($entity->isModified()){
            $entity->setDateUpdate((new \DateTime()));
       }
        parent::save($entity);
    }


    /**
     * @param PaginationInterface|PageCriteriaInterface $criteria
     * @param ModelCriteria|PageQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

        $dbCriteria
            ->_if($criteria->getSearchByCode())
            ->filterByCode('%' . $criteria->getSearchByCode() . '%', Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getSearchByUrl())
            ->filterByUrl('%' . $criteria->getSearchByUrl() . '%', Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getSearchByTitle())
            ->filterByTitle('%' . $criteria->getSearchByTitle() . '%', Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getSearchByScript())
            ->filterByScript('%' . $criteria->getSearchByScript() . '%', Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getFilterBySystem() !== null)
            ->filterBySystem($criteria->getFilterBySystem() === true ? 'Y' : 'N')
            ->_endif()
            ->_if($criteria->getFilterByActive() !== null)
            ->filterByActive($criteria->getFilterByActive() === true ? 'Y' : 'N')
            ->_endif()
            ->_if($criteria->getFilterByTemplate())
            ->filterByTemplate($criteria->getFilterByTemplate())
            ->_endif()
            ->_if($criteria->getFilterBySiteId() !== null)
            ->filterByDomainId($criteria->getFilterBySiteId())
            ->_endif()
        ;
    }


    protected function createCollection(): CollectionInterface
    {
        return new PageCollection();
    }
}