<?php

namespace Diamond\Infrastructure\Models\StatRule\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\StatRule\StatRule as ChildStatRule;
use Diamond\Infrastructure\Models\StatRule\StatRuleQuery as ChildStatRuleQuery;
use Diamond\Infrastructure\Models\StatRule\Map\StatRuleTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_stat_rules' table.
 *
 *
 *
 * @method     ChildStatRuleQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildStatRuleQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildStatRuleQuery orderByClientType($order = Criteria::ASC) Order by the client_type column
 * @method     ChildStatRuleQuery orderByUriMask($order = Criteria::ASC) Order by the uri_mask column
 * @method     ChildStatRuleQuery orderByIpMask($order = Criteria::ASC) Order by the ip_mask column
 * @method     ChildStatRuleQuery orderByAgentMask($order = Criteria::ASC) Order by the agent_mask column
 * @method     ChildStatRuleQuery orderByHostMask($order = Criteria::ASC) Order by the host_mask column
 * @method     ChildStatRuleQuery orderByRule($order = Criteria::ASC) Order by the rule column
 * @method     ChildStatRuleQuery orderByPeriod($order = Criteria::ASC) Order by the period column
 * @method     ChildStatRuleQuery orderByBanRate($order = Criteria::ASC) Order by the ban_rate column
 * @method     ChildStatRuleQuery orderByBanUri($order = Criteria::ASC) Order by the ban_uri column
 * @method     ChildStatRuleQuery orderByBanPeriod($order = Criteria::ASC) Order by the ban_period column
 *
 * @method     ChildStatRuleQuery groupById() Group by the id column
 * @method     ChildStatRuleQuery groupByName() Group by the name column
 * @method     ChildStatRuleQuery groupByClientType() Group by the client_type column
 * @method     ChildStatRuleQuery groupByUriMask() Group by the uri_mask column
 * @method     ChildStatRuleQuery groupByIpMask() Group by the ip_mask column
 * @method     ChildStatRuleQuery groupByAgentMask() Group by the agent_mask column
 * @method     ChildStatRuleQuery groupByHostMask() Group by the host_mask column
 * @method     ChildStatRuleQuery groupByRule() Group by the rule column
 * @method     ChildStatRuleQuery groupByPeriod() Group by the period column
 * @method     ChildStatRuleQuery groupByBanRate() Group by the ban_rate column
 * @method     ChildStatRuleQuery groupByBanUri() Group by the ban_uri column
 * @method     ChildStatRuleQuery groupByBanPeriod() Group by the ban_period column
 *
 * @method     ChildStatRuleQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildStatRuleQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildStatRuleQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildStatRuleQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildStatRuleQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildStatRuleQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildStatRule|null findOne(?ConnectionInterface $con = null) Return the first ChildStatRule matching the query
 * @method     ChildStatRule findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildStatRule matching the query, or a new ChildStatRule object populated from the query conditions when no match is found
 *
 * @method     ChildStatRule|null findOneById(int $id) Return the first ChildStatRule filtered by the id column
 * @method     ChildStatRule|null findOneByName(string $name) Return the first ChildStatRule filtered by the name column
 * @method     ChildStatRule|null findOneByClientType(string $client_type) Return the first ChildStatRule filtered by the client_type column
 * @method     ChildStatRule|null findOneByUriMask(string $uri_mask) Return the first ChildStatRule filtered by the uri_mask column
 * @method     ChildStatRule|null findOneByIpMask(string $ip_mask) Return the first ChildStatRule filtered by the ip_mask column
 * @method     ChildStatRule|null findOneByAgentMask(string $agent_mask) Return the first ChildStatRule filtered by the agent_mask column
 * @method     ChildStatRule|null findOneByHostMask(string $host_mask) Return the first ChildStatRule filtered by the host_mask column
 * @method     ChildStatRule|null findOneByRule(string $rule) Return the first ChildStatRule filtered by the rule column
 * @method     ChildStatRule|null findOneByPeriod(int $period) Return the first ChildStatRule filtered by the period column
 * @method     ChildStatRule|null findOneByBanRate(int $ban_rate) Return the first ChildStatRule filtered by the ban_rate column
 * @method     ChildStatRule|null findOneByBanUri(string $ban_uri) Return the first ChildStatRule filtered by the ban_uri column
 * @method     ChildStatRule|null findOneByBanPeriod(int $ban_period) Return the first ChildStatRule filtered by the ban_period column *

 * @method     ChildStatRule requirePk($key, ?ConnectionInterface $con = null) Return the ChildStatRule by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatRule requireOne(?ConnectionInterface $con = null) Return the first ChildStatRule matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildStatRule requireOneById(int $id) Return the first ChildStatRule filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatRule requireOneByName(string $name) Return the first ChildStatRule filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatRule requireOneByClientType(string $client_type) Return the first ChildStatRule filtered by the client_type column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatRule requireOneByUriMask(string $uri_mask) Return the first ChildStatRule filtered by the uri_mask column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatRule requireOneByIpMask(string $ip_mask) Return the first ChildStatRule filtered by the ip_mask column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatRule requireOneByAgentMask(string $agent_mask) Return the first ChildStatRule filtered by the agent_mask column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatRule requireOneByHostMask(string $host_mask) Return the first ChildStatRule filtered by the host_mask column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatRule requireOneByRule(string $rule) Return the first ChildStatRule filtered by the rule column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatRule requireOneByPeriod(int $period) Return the first ChildStatRule filtered by the period column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatRule requireOneByBanRate(int $ban_rate) Return the first ChildStatRule filtered by the ban_rate column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatRule requireOneByBanUri(string $ban_uri) Return the first ChildStatRule filtered by the ban_uri column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatRule requireOneByBanPeriod(int $ban_period) Return the first ChildStatRule filtered by the ban_period column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildStatRule[]|Collection find(?ConnectionInterface $con = null) Return ChildStatRule objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildStatRule> find(?ConnectionInterface $con = null) Return ChildStatRule objects based on current ModelCriteria
 * @method     ChildStatRule[]|Collection findById(int $id) Return ChildStatRule objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildStatRule> findById(int $id) Return ChildStatRule objects filtered by the id column
 * @method     ChildStatRule[]|Collection findByName(string $name) Return ChildStatRule objects filtered by the name column
 * @psalm-method Collection&\Traversable<ChildStatRule> findByName(string $name) Return ChildStatRule objects filtered by the name column
 * @method     ChildStatRule[]|Collection findByClientType(string $client_type) Return ChildStatRule objects filtered by the client_type column
 * @psalm-method Collection&\Traversable<ChildStatRule> findByClientType(string $client_type) Return ChildStatRule objects filtered by the client_type column
 * @method     ChildStatRule[]|Collection findByUriMask(string $uri_mask) Return ChildStatRule objects filtered by the uri_mask column
 * @psalm-method Collection&\Traversable<ChildStatRule> findByUriMask(string $uri_mask) Return ChildStatRule objects filtered by the uri_mask column
 * @method     ChildStatRule[]|Collection findByIpMask(string $ip_mask) Return ChildStatRule objects filtered by the ip_mask column
 * @psalm-method Collection&\Traversable<ChildStatRule> findByIpMask(string $ip_mask) Return ChildStatRule objects filtered by the ip_mask column
 * @method     ChildStatRule[]|Collection findByAgentMask(string $agent_mask) Return ChildStatRule objects filtered by the agent_mask column
 * @psalm-method Collection&\Traversable<ChildStatRule> findByAgentMask(string $agent_mask) Return ChildStatRule objects filtered by the agent_mask column
 * @method     ChildStatRule[]|Collection findByHostMask(string $host_mask) Return ChildStatRule objects filtered by the host_mask column
 * @psalm-method Collection&\Traversable<ChildStatRule> findByHostMask(string $host_mask) Return ChildStatRule objects filtered by the host_mask column
 * @method     ChildStatRule[]|Collection findByRule(string $rule) Return ChildStatRule objects filtered by the rule column
 * @psalm-method Collection&\Traversable<ChildStatRule> findByRule(string $rule) Return ChildStatRule objects filtered by the rule column
 * @method     ChildStatRule[]|Collection findByPeriod(int $period) Return ChildStatRule objects filtered by the period column
 * @psalm-method Collection&\Traversable<ChildStatRule> findByPeriod(int $period) Return ChildStatRule objects filtered by the period column
 * @method     ChildStatRule[]|Collection findByBanRate(int $ban_rate) Return ChildStatRule objects filtered by the ban_rate column
 * @psalm-method Collection&\Traversable<ChildStatRule> findByBanRate(int $ban_rate) Return ChildStatRule objects filtered by the ban_rate column
 * @method     ChildStatRule[]|Collection findByBanUri(string $ban_uri) Return ChildStatRule objects filtered by the ban_uri column
 * @psalm-method Collection&\Traversable<ChildStatRule> findByBanUri(string $ban_uri) Return ChildStatRule objects filtered by the ban_uri column
 * @method     ChildStatRule[]|Collection findByBanPeriod(int $ban_period) Return ChildStatRule objects filtered by the ban_period column
 * @psalm-method Collection&\Traversable<ChildStatRule> findByBanPeriod(int $ban_period) Return ChildStatRule objects filtered by the ban_period column
 * @method     ChildStatRule[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildStatRule> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class StatRuleQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Infrastructure\Models\StatRule\Base\StatRuleQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Infrastructure\\Models\\StatRule\\StatRule', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildStatRuleQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildStatRuleQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildStatRuleQuery) {
            return $criteria;
        }
        $query = new ChildStatRuleQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildStatRule|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(StatRuleTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = StatRuleTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildStatRule A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name`, `client_type`, `uri_mask`, `ip_mask`, `agent_mask`, `host_mask`, `rule`, `period`, `ban_rate`, `ban_uri`, `ban_period` FROM `_stat_rules` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildStatRule $obj */
            $obj = new ChildStatRule();
            $obj->hydrate($row);
            StatRuleTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildStatRule|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(StatRuleTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(StatRuleTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(StatRuleTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(StatRuleTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatRuleTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * $query->filterByName(['foo', 'bar']); // WHERE name IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $name The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByName($name = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatRuleTableMap::COL_NAME, $name, $comparison);

        return $this;
    }

    /**
     * Filter the query on the client_type column
     *
     * Example usage:
     * <code>
     * $query->filterByClientType('fooValue');   // WHERE client_type = 'fooValue'
     * $query->filterByClientType('%fooValue%', Criteria::LIKE); // WHERE client_type LIKE '%fooValue%'
     * $query->filterByClientType(['foo', 'bar']); // WHERE client_type IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $clientType The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByClientType($clientType = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($clientType)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatRuleTableMap::COL_CLIENT_TYPE, $clientType, $comparison);

        return $this;
    }

    /**
     * Filter the query on the uri_mask column
     *
     * Example usage:
     * <code>
     * $query->filterByUriMask('fooValue');   // WHERE uri_mask = 'fooValue'
     * $query->filterByUriMask('%fooValue%', Criteria::LIKE); // WHERE uri_mask LIKE '%fooValue%'
     * $query->filterByUriMask(['foo', 'bar']); // WHERE uri_mask IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $uriMask The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByUriMask($uriMask = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($uriMask)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatRuleTableMap::COL_URI_MASK, $uriMask, $comparison);

        return $this;
    }

    /**
     * Filter the query on the ip_mask column
     *
     * Example usage:
     * <code>
     * $query->filterByIpMask('fooValue');   // WHERE ip_mask = 'fooValue'
     * $query->filterByIpMask('%fooValue%', Criteria::LIKE); // WHERE ip_mask LIKE '%fooValue%'
     * $query->filterByIpMask(['foo', 'bar']); // WHERE ip_mask IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $ipMask The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByIpMask($ipMask = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($ipMask)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatRuleTableMap::COL_IP_MASK, $ipMask, $comparison);

        return $this;
    }

    /**
     * Filter the query on the agent_mask column
     *
     * Example usage:
     * <code>
     * $query->filterByAgentMask('fooValue');   // WHERE agent_mask = 'fooValue'
     * $query->filterByAgentMask('%fooValue%', Criteria::LIKE); // WHERE agent_mask LIKE '%fooValue%'
     * $query->filterByAgentMask(['foo', 'bar']); // WHERE agent_mask IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $agentMask The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByAgentMask($agentMask = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($agentMask)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatRuleTableMap::COL_AGENT_MASK, $agentMask, $comparison);

        return $this;
    }

    /**
     * Filter the query on the host_mask column
     *
     * Example usage:
     * <code>
     * $query->filterByHostMask('fooValue');   // WHERE host_mask = 'fooValue'
     * $query->filterByHostMask('%fooValue%', Criteria::LIKE); // WHERE host_mask LIKE '%fooValue%'
     * $query->filterByHostMask(['foo', 'bar']); // WHERE host_mask IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $hostMask The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByHostMask($hostMask = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($hostMask)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatRuleTableMap::COL_HOST_MASK, $hostMask, $comparison);

        return $this;
    }

    /**
     * Filter the query on the rule column
     *
     * Example usage:
     * <code>
     * $query->filterByRule('fooValue');   // WHERE rule = 'fooValue'
     * $query->filterByRule('%fooValue%', Criteria::LIKE); // WHERE rule LIKE '%fooValue%'
     * $query->filterByRule(['foo', 'bar']); // WHERE rule IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $rule The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByRule($rule = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($rule)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatRuleTableMap::COL_RULE, $rule, $comparison);

        return $this;
    }

    /**
     * Filter the query on the period column
     *
     * Example usage:
     * <code>
     * $query->filterByPeriod(1234); // WHERE period = 1234
     * $query->filterByPeriod(array(12, 34)); // WHERE period IN (12, 34)
     * $query->filterByPeriod(array('min' => 12)); // WHERE period > 12
     * </code>
     *
     * @param mixed $period The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPeriod($period = null, ?string $comparison = null)
    {
        if (is_array($period)) {
            $useMinMax = false;
            if (isset($period['min'])) {
                $this->addUsingAlias(StatRuleTableMap::COL_PERIOD, $period['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($period['max'])) {
                $this->addUsingAlias(StatRuleTableMap::COL_PERIOD, $period['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatRuleTableMap::COL_PERIOD, $period, $comparison);

        return $this;
    }

    /**
     * Filter the query on the ban_rate column
     *
     * Example usage:
     * <code>
     * $query->filterByBanRate(1234); // WHERE ban_rate = 1234
     * $query->filterByBanRate(array(12, 34)); // WHERE ban_rate IN (12, 34)
     * $query->filterByBanRate(array('min' => 12)); // WHERE ban_rate > 12
     * </code>
     *
     * @param mixed $banRate The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByBanRate($banRate = null, ?string $comparison = null)
    {
        if (is_array($banRate)) {
            $useMinMax = false;
            if (isset($banRate['min'])) {
                $this->addUsingAlias(StatRuleTableMap::COL_BAN_RATE, $banRate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($banRate['max'])) {
                $this->addUsingAlias(StatRuleTableMap::COL_BAN_RATE, $banRate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatRuleTableMap::COL_BAN_RATE, $banRate, $comparison);

        return $this;
    }

    /**
     * Filter the query on the ban_uri column
     *
     * Example usage:
     * <code>
     * $query->filterByBanUri('fooValue');   // WHERE ban_uri = 'fooValue'
     * $query->filterByBanUri('%fooValue%', Criteria::LIKE); // WHERE ban_uri LIKE '%fooValue%'
     * $query->filterByBanUri(['foo', 'bar']); // WHERE ban_uri IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $banUri The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByBanUri($banUri = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($banUri)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatRuleTableMap::COL_BAN_URI, $banUri, $comparison);

        return $this;
    }

    /**
     * Filter the query on the ban_period column
     *
     * Example usage:
     * <code>
     * $query->filterByBanPeriod(1234); // WHERE ban_period = 1234
     * $query->filterByBanPeriod(array(12, 34)); // WHERE ban_period IN (12, 34)
     * $query->filterByBanPeriod(array('min' => 12)); // WHERE ban_period > 12
     * </code>
     *
     * @param mixed $banPeriod The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByBanPeriod($banPeriod = null, ?string $comparison = null)
    {
        if (is_array($banPeriod)) {
            $useMinMax = false;
            if (isset($banPeriod['min'])) {
                $this->addUsingAlias(StatRuleTableMap::COL_BAN_PERIOD, $banPeriod['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($banPeriod['max'])) {
                $this->addUsingAlias(StatRuleTableMap::COL_BAN_PERIOD, $banPeriod['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatRuleTableMap::COL_BAN_PERIOD, $banPeriod, $comparison);

        return $this;
    }

    /**
     * Exclude object from result
     *
     * @param ChildStatRule $statRule Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($statRule = null)
    {
        if ($statRule) {
            $this->addUsingAlias(StatRuleTableMap::COL_ID, $statRule->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _stat_rules table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatRuleTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            StatRuleTableMap::clearInstancePool();
            StatRuleTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatRuleTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(StatRuleTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            StatRuleTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            StatRuleTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
