<?php

namespace Diamond\Infrastructure\Models\Stat\Base;

use \DateTime;
use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\Stat\StatQuery as ChildStatQuery;
use Diamond\Infrastructure\Models\Stat\Map\StatTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;
use Propel\Runtime\Util\PropelDateTime;

/**
 * Base class that represents a row from the '_stat' table.
 *
 *
 *
 * @package    propel.generator.Diamond.Infrastructure.Models.Stat.Base
 */
abstract class Stat implements ActiveRecordInterface
{
    /**
     * TableMap class name
     *
     * @var string
     */
    public const TABLE_MAP = '\\Diamond\\Infrastructure\\Models\\Stat\\Map\\StatTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var bool
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var bool
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = [];

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = [];

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the datetime field.
     *
     * Note: this column has a database default value of: (expression) CURRENT_TIMESTAMP
     * @var        DateTime
     */
    protected $datetime;

    /**
     * The value for the remote_addr field.
     *
     * @var        string
     */
    protected $remote_addr;

    /**
     * The value for the requested_page field.
     *
     * @var        string
     */
    protected $requested_page;

    /**
     * The value for the request_uri field.
     *
     * @var        string|null
     */
    protected $request_uri;

    /**
     * The value for the user_agent field.
     *
     * @var        string|null
     */
    protected $user_agent;

    /**
     * The value for the request_method field.
     *
     * @var        string|null
     */
    protected $request_method;

    /**
     * The value for the referer field.
     *
     * @var        string|null
     */
    protected $referer;

    /**
     * The value for the elapsed_time field.
     *
     * @var        string|null
     */
    protected $elapsed_time;

    /**
     * The value for the memory field.
     *
     * @var        string|null
     */
    protected $memory;

    /**
     * The value for the client_type field.
     *
     * Note: this column has a database default value of: 'other'
     * @var        string
     */
    protected $client_type;

    /**
     * The value for the host field.
     *
     * @var        string|null
     */
    protected $host;

    /**
     * The value for the client field.
     *
     * @var        string|null
     */
    protected $client;

    /**
     * The value for the platform field.
     *
     * @var        string|null
     */
    protected $platform;

    /**
     * The value for the post_data field.
     *
     * @var        string|null
     */
    protected $post_data;

    /**
     * The value for the client_user field.
     *
     * @var        int|null
     */
    protected $client_user;

    /**
     * The value for the admin_user field.
     *
     * @var        int|null
     */
    protected $admin_user;

    /**
     * The value for the error_message field.
     *
     * @var        string|null
     */
    protected $error_message;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var bool
     */
    protected $alreadyInSave = false;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues(): void
    {
        $this->client_type = 'other';
    }

    /**
     * Initializes internal state of Diamond\Infrastructure\Models\Stat\Base\Stat object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return bool True if the object has been modified.
     */
    public function isModified(): bool
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param string $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return bool True if $col has been modified.
     */
    public function isColumnModified(string $col): bool
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns(): array
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return bool True, if the object has never been persisted.
     */
    public function isNew(): bool
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param bool $b the state of the object.
     */
    public function setNew(bool $b): void
    {
        $this->new = $b;
    }

    /**
     * Whether this object has been deleted.
     * @return bool The deleted state of this object.
     */
    public function isDeleted(): bool
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param bool $b The deleted state of this object.
     * @return void
     */
    public function setDeleted(bool $b): void
    {
        $this->deleted = $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified(?string $col = null): void
    {
        if (null !== $col) {
            unset($this->modifiedColumns[$col]);
        } else {
            $this->modifiedColumns = [];
        }
    }

    /**
     * Compares this with another <code>Stat</code> instance.  If
     * <code>obj</code> is an instance of <code>Stat</code>, delegates to
     * <code>equals(Stat)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param mixed $obj The object to compare to.
     * @return bool Whether equal to the object specified.
     */
    public function equals($obj): bool
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns(): array
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return bool
     */
    public function hasVirtualColumn(string $name): bool
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return mixed
     *
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getVirtualColumn(string $name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of nonexistent virtual column `%s`.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @param mixed $value The value to give to the virtual column
     *
     * @return $this The current object, for fluid interface
     */
    public function setVirtualColumn(string $name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param string $msg
     * @param int $priority One of the Propel::LOG_* logging levels
     * @return void
     */
    protected function log(string $msg, int $priority = Propel::LOG_INFO): void
    {
        Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param \Propel\Runtime\Parser\AbstractParser|string $parser An AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME, TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM. Defaults to TableMap::TYPE_PHPNAME.
     * @return string The exported data
     */
    public function exportTo($parser, bool $includeLazyLoadColumns = true, string $keyType = TableMap::TYPE_PHPNAME): string
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray($keyType, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     *
     * @return array<string>
     */
    public function __sleep(): array
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [optionally formatted] temporal [datetime] column value.
     *
     *
     * @param string|null $format The date/time format string (either date()-style or strftime()-style).
     *   If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), and 0 if column value is 0000-00-00 00:00:00.
     *
     * @throws \Propel\Runtime\Exception\PropelException - if unable to parse/validate the date/time value.
     *
     * @psalm-return ($format is null ? DateTime : string)
     */
    public function getDatetime($format = null)
    {
        if ($format === null) {
            return $this->datetime;
        } else {
            return $this->datetime instanceof \DateTimeInterface ? $this->datetime->format($format) : null;
        }
    }

    /**
     * Get the [remote_addr] column value.
     *
     * @return string
     */
    public function getRemoteAddr()
    {
        return $this->remote_addr;
    }

    /**
     * Get the [requested_page] column value.
     *
     * @return string
     */
    public function getRequestedPage()
    {
        return $this->requested_page;
    }

    /**
     * Get the [request_uri] column value.
     *
     * @return string|null
     */
    public function getRequestUri()
    {
        return $this->request_uri;
    }

    /**
     * Get the [user_agent] column value.
     *
     * @return string|null
     */
    public function getUserAgent()
    {
        return $this->user_agent;
    }

    /**
     * Get the [request_method] column value.
     *
     * @return string|null
     */
    public function getRequestMethod()
    {
        return $this->request_method;
    }

    /**
     * Get the [referer] column value.
     *
     * @return string|null
     */
    public function getReferer()
    {
        return $this->referer;
    }

    /**
     * Get the [elapsed_time] column value.
     *
     * @return string|null
     */
    public function getElapsedTime()
    {
        return $this->elapsed_time;
    }

    /**
     * Get the [memory] column value.
     *
     * @return string|null
     */
    public function getMemory()
    {
        return $this->memory;
    }

    /**
     * Get the [client_type] column value.
     *
     * @return string
     */
    public function getClientType()
    {
        return $this->client_type;
    }

    /**
     * Get the [host] column value.
     *
     * @return string|null
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * Get the [client] column value.
     *
     * @return string|null
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * Get the [platform] column value.
     *
     * @return string|null
     */
    public function getPlatform()
    {
        return $this->platform;
    }

    /**
     * Get the [post_data] column value.
     *
     * @return string|null
     */
    public function getPostData()
    {
        return $this->post_data;
    }

    /**
     * Get the [client_user] column value.
     *
     * @return int|null
     */
    public function getClientUser()
    {
        return $this->client_user;
    }

    /**
     * Get the [admin_user] column value.
     *
     * @return int|null
     */
    public function getAdminUser()
    {
        return $this->admin_user;
    }

    /**
     * Get the [error_message] column value.
     *
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->error_message;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[StatTableMap::COL_ID] = true;
        }

        return $this;
    }

    /**
     * Sets the value of [datetime] column to a normalized version of the date/time value specified.
     *
     * @param string|integer|\DateTimeInterface $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this The current object (for fluent API support)
     */
    public function setDatetime($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->datetime !== null || $dt !== null) {
            if ($this->datetime === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->datetime->format("Y-m-d H:i:s.u")) {
                $this->datetime = $dt === null ? null : clone $dt;
                $this->modifiedColumns[StatTableMap::COL_DATETIME] = true;
            }
        } // if either are not null

        return $this;
    }

    /**
     * Set the value of [remote_addr] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setRemoteAddr($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->remote_addr !== $v) {
            $this->remote_addr = $v;
            $this->modifiedColumns[StatTableMap::COL_REMOTE_ADDR] = true;
        }

        return $this;
    }

    /**
     * Set the value of [requested_page] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setRequestedPage($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->requested_page !== $v) {
            $this->requested_page = $v;
            $this->modifiedColumns[StatTableMap::COL_REQUESTED_PAGE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [request_uri] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setRequestUri($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->request_uri !== $v) {
            $this->request_uri = $v;
            $this->modifiedColumns[StatTableMap::COL_REQUEST_URI] = true;
        }

        return $this;
    }

    /**
     * Set the value of [user_agent] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setUserAgent($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->user_agent !== $v) {
            $this->user_agent = $v;
            $this->modifiedColumns[StatTableMap::COL_USER_AGENT] = true;
        }

        return $this;
    }

    /**
     * Set the value of [request_method] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setRequestMethod($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->request_method !== $v) {
            $this->request_method = $v;
            $this->modifiedColumns[StatTableMap::COL_REQUEST_METHOD] = true;
        }

        return $this;
    }

    /**
     * Set the value of [referer] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setReferer($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->referer !== $v) {
            $this->referer = $v;
            $this->modifiedColumns[StatTableMap::COL_REFERER] = true;
        }

        return $this;
    }

    /**
     * Set the value of [elapsed_time] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setElapsedTime($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->elapsed_time !== $v) {
            $this->elapsed_time = $v;
            $this->modifiedColumns[StatTableMap::COL_ELAPSED_TIME] = true;
        }

        return $this;
    }

    /**
     * Set the value of [memory] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setMemory($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->memory !== $v) {
            $this->memory = $v;
            $this->modifiedColumns[StatTableMap::COL_MEMORY] = true;
        }

        return $this;
    }

    /**
     * Set the value of [client_type] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setClientType($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->client_type !== $v) {
            $this->client_type = $v;
            $this->modifiedColumns[StatTableMap::COL_CLIENT_TYPE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [host] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setHost($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->host !== $v) {
            $this->host = $v;
            $this->modifiedColumns[StatTableMap::COL_HOST] = true;
        }

        return $this;
    }

    /**
     * Set the value of [client] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setClient($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->client !== $v) {
            $this->client = $v;
            $this->modifiedColumns[StatTableMap::COL_CLIENT] = true;
        }

        return $this;
    }

    /**
     * Set the value of [platform] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setPlatform($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->platform !== $v) {
            $this->platform = $v;
            $this->modifiedColumns[StatTableMap::COL_PLATFORM] = true;
        }

        return $this;
    }

    /**
     * Set the value of [post_data] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setPostData($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->post_data !== $v) {
            $this->post_data = $v;
            $this->modifiedColumns[StatTableMap::COL_POST_DATA] = true;
        }

        return $this;
    }

    /**
     * Set the value of [client_user] column.
     *
     * @param int|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setClientUser($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->client_user !== $v) {
            $this->client_user = $v;
            $this->modifiedColumns[StatTableMap::COL_CLIENT_USER] = true;
        }

        return $this;
    }

    /**
     * Set the value of [admin_user] column.
     *
     * @param int|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setAdminUser($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->admin_user !== $v) {
            $this->admin_user = $v;
            $this->modifiedColumns[StatTableMap::COL_ADMIN_USER] = true;
        }

        return $this;
    }

    /**
     * Set the value of [error_message] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setErrorMessage($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->error_message !== $v) {
            $this->error_message = $v;
            $this->modifiedColumns[StatTableMap::COL_ERROR_MESSAGE] = true;
        }

        return $this;
    }

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return bool Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues(): bool
    {
            if ($this->client_type !== 'other') {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    }

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by DataFetcher->fetch().
     * @param int $startcol 0-based offset column which indicates which resultset column to start with.
     * @param bool $rehydrate Whether this object is being re-hydrated from the database.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int next starting column
     * @throws \Propel\Runtime\Exception\PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate(array $row, int $startcol = 0, bool $rehydrate = false, string $indexType = TableMap::TYPE_NUM): int
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : StatTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : StatTableMap::translateFieldName('Datetime', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->datetime = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : StatTableMap::translateFieldName('RemoteAddr', TableMap::TYPE_PHPNAME, $indexType)];
            $this->remote_addr = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : StatTableMap::translateFieldName('RequestedPage', TableMap::TYPE_PHPNAME, $indexType)];
            $this->requested_page = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : StatTableMap::translateFieldName('RequestUri', TableMap::TYPE_PHPNAME, $indexType)];
            $this->request_uri = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : StatTableMap::translateFieldName('UserAgent', TableMap::TYPE_PHPNAME, $indexType)];
            $this->user_agent = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : StatTableMap::translateFieldName('RequestMethod', TableMap::TYPE_PHPNAME, $indexType)];
            $this->request_method = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : StatTableMap::translateFieldName('Referer', TableMap::TYPE_PHPNAME, $indexType)];
            $this->referer = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 8 + $startcol : StatTableMap::translateFieldName('ElapsedTime', TableMap::TYPE_PHPNAME, $indexType)];
            $this->elapsed_time = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 9 + $startcol : StatTableMap::translateFieldName('Memory', TableMap::TYPE_PHPNAME, $indexType)];
            $this->memory = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 10 + $startcol : StatTableMap::translateFieldName('ClientType', TableMap::TYPE_PHPNAME, $indexType)];
            $this->client_type = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 11 + $startcol : StatTableMap::translateFieldName('Host', TableMap::TYPE_PHPNAME, $indexType)];
            $this->host = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 12 + $startcol : StatTableMap::translateFieldName('Client', TableMap::TYPE_PHPNAME, $indexType)];
            $this->client = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 13 + $startcol : StatTableMap::translateFieldName('Platform', TableMap::TYPE_PHPNAME, $indexType)];
            $this->platform = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 14 + $startcol : StatTableMap::translateFieldName('PostData', TableMap::TYPE_PHPNAME, $indexType)];
            $this->post_data = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 15 + $startcol : StatTableMap::translateFieldName('ClientUser', TableMap::TYPE_PHPNAME, $indexType)];
            $this->client_user = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 16 + $startcol : StatTableMap::translateFieldName('AdminUser', TableMap::TYPE_PHPNAME, $indexType)];
            $this->admin_user = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 17 + $startcol : StatTableMap::translateFieldName('ErrorMessage', TableMap::TYPE_PHPNAME, $indexType)];
            $this->error_message = (null !== $col) ? (string) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 18; // 18 = StatTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Diamond\\Infrastructure\\Models\\Stat\\Stat'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function ensureConsistency(): void
    {
    }

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param bool $deep (optional) Whether to also de-associated any related objects.
     * @param ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload(bool $deep = false, ?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(StatTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildStatQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param ConnectionInterface $con
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     * @see Stat::setDeleted()
     * @see Stat::isDeleted()
     */
    public function delete(?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildStatQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    public function save(?ConnectionInterface $con = null): int
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                StatTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con): int
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    }

    /**
     * Insert the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con): void
    {
        $modifiedColumns = [];
        $index = 0;

        $this->modifiedColumns[StatTableMap::COL_ID] = true;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . StatTableMap::COL_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(StatTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(StatTableMap::COL_DATETIME)) {
            $modifiedColumns[':p' . $index++]  = '`datetime`';
        }
        if ($this->isColumnModified(StatTableMap::COL_REMOTE_ADDR)) {
            $modifiedColumns[':p' . $index++]  = '`remote_addr`';
        }
        if ($this->isColumnModified(StatTableMap::COL_REQUESTED_PAGE)) {
            $modifiedColumns[':p' . $index++]  = '`requested_page`';
        }
        if ($this->isColumnModified(StatTableMap::COL_REQUEST_URI)) {
            $modifiedColumns[':p' . $index++]  = '`request_uri`';
        }
        if ($this->isColumnModified(StatTableMap::COL_USER_AGENT)) {
            $modifiedColumns[':p' . $index++]  = '`user_agent`';
        }
        if ($this->isColumnModified(StatTableMap::COL_REQUEST_METHOD)) {
            $modifiedColumns[':p' . $index++]  = '`request_method`';
        }
        if ($this->isColumnModified(StatTableMap::COL_REFERER)) {
            $modifiedColumns[':p' . $index++]  = '`referer`';
        }
        if ($this->isColumnModified(StatTableMap::COL_ELAPSED_TIME)) {
            $modifiedColumns[':p' . $index++]  = '`elapsed_time`';
        }
        if ($this->isColumnModified(StatTableMap::COL_MEMORY)) {
            $modifiedColumns[':p' . $index++]  = '`memory`';
        }
        if ($this->isColumnModified(StatTableMap::COL_CLIENT_TYPE)) {
            $modifiedColumns[':p' . $index++]  = '`client_type`';
        }
        if ($this->isColumnModified(StatTableMap::COL_HOST)) {
            $modifiedColumns[':p' . $index++]  = '`host`';
        }
        if ($this->isColumnModified(StatTableMap::COL_CLIENT)) {
            $modifiedColumns[':p' . $index++]  = '`client`';
        }
        if ($this->isColumnModified(StatTableMap::COL_PLATFORM)) {
            $modifiedColumns[':p' . $index++]  = '`platform`';
        }
        if ($this->isColumnModified(StatTableMap::COL_POST_DATA)) {
            $modifiedColumns[':p' . $index++]  = '`post_data`';
        }
        if ($this->isColumnModified(StatTableMap::COL_CLIENT_USER)) {
            $modifiedColumns[':p' . $index++]  = '`client_user`';
        }
        if ($this->isColumnModified(StatTableMap::COL_ADMIN_USER)) {
            $modifiedColumns[':p' . $index++]  = '`admin_user`';
        }
        if ($this->isColumnModified(StatTableMap::COL_ERROR_MESSAGE)) {
            $modifiedColumns[':p' . $index++]  = '`error_message`';
        }

        $sql = sprintf(
            'INSERT INTO `_stat` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`datetime`':
                        $stmt->bindValue($identifier, $this->datetime ? $this->datetime->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`remote_addr`':
                        $stmt->bindValue($identifier, $this->remote_addr, PDO::PARAM_STR);
                        break;
                    case '`requested_page`':
                        $stmt->bindValue($identifier, $this->requested_page, PDO::PARAM_STR);
                        break;
                    case '`request_uri`':
                        $stmt->bindValue($identifier, $this->request_uri, PDO::PARAM_STR);
                        break;
                    case '`user_agent`':
                        $stmt->bindValue($identifier, $this->user_agent, PDO::PARAM_STR);
                        break;
                    case '`request_method`':
                        $stmt->bindValue($identifier, $this->request_method, PDO::PARAM_STR);
                        break;
                    case '`referer`':
                        $stmt->bindValue($identifier, $this->referer, PDO::PARAM_STR);
                        break;
                    case '`elapsed_time`':
                        $stmt->bindValue($identifier, $this->elapsed_time, PDO::PARAM_STR);
                        break;
                    case '`memory`':
                        $stmt->bindValue($identifier, $this->memory, PDO::PARAM_STR);
                        break;
                    case '`client_type`':
                        $stmt->bindValue($identifier, $this->client_type, PDO::PARAM_STR);
                        break;
                    case '`host`':
                        $stmt->bindValue($identifier, $this->host, PDO::PARAM_STR);
                        break;
                    case '`client`':
                        $stmt->bindValue($identifier, $this->client, PDO::PARAM_STR);
                        break;
                    case '`platform`':
                        $stmt->bindValue($identifier, $this->platform, PDO::PARAM_STR);
                        break;
                    case '`post_data`':
                        $stmt->bindValue($identifier, $this->post_data, PDO::PARAM_STR);
                        break;
                    case '`client_user`':
                        $stmt->bindValue($identifier, $this->client_user, PDO::PARAM_INT);
                        break;
                    case '`admin_user`':
                        $stmt->bindValue($identifier, $this->admin_user, PDO::PARAM_INT);
                        break;
                    case '`error_message`':
                        $stmt->bindValue($identifier, $this->error_message, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @return int Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con): int
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName(string $name, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = StatTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos Position in XML schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition(int $pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();

            case 1:
                return $this->getDatetime();

            case 2:
                return $this->getRemoteAddr();

            case 3:
                return $this->getRequestedPage();

            case 4:
                return $this->getRequestUri();

            case 5:
                return $this->getUserAgent();

            case 6:
                return $this->getRequestMethod();

            case 7:
                return $this->getReferer();

            case 8:
                return $this->getElapsedTime();

            case 9:
                return $this->getMemory();

            case 10:
                return $this->getClientType();

            case 11:
                return $this->getHost();

            case 12:
                return $this->getClient();

            case 13:
                return $this->getPlatform();

            case 14:
                return $this->getPostData();

            case 15:
                return $this->getClientUser();

            case 16:
                return $this->getAdminUser();

            case 17:
                return $this->getErrorMessage();

            default:
                return null;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param array $alreadyDumpedObjects List of objects to skip to avoid recursion
     *
     * @return array An associative array containing the field names (as keys) and field values
     */
    public function toArray(string $keyType = TableMap::TYPE_PHPNAME, bool $includeLazyLoadColumns = true, array $alreadyDumpedObjects = []): array
    {
        if (isset($alreadyDumpedObjects['Stat'][$this->hashCode()])) {
            return ['*RECURSION*'];
        }
        $alreadyDumpedObjects['Stat'][$this->hashCode()] = true;
        $keys = StatTableMap::getFieldNames($keyType);
        $result = [
            $keys[0] => $this->getId(),
            $keys[1] => $this->getDatetime(),
            $keys[2] => $this->getRemoteAddr(),
            $keys[3] => $this->getRequestedPage(),
            $keys[4] => $this->getRequestUri(),
            $keys[5] => $this->getUserAgent(),
            $keys[6] => $this->getRequestMethod(),
            $keys[7] => $this->getReferer(),
            $keys[8] => $this->getElapsedTime(),
            $keys[9] => $this->getMemory(),
            $keys[10] => $this->getClientType(),
            $keys[11] => $this->getHost(),
            $keys[12] => $this->getClient(),
            $keys[13] => $this->getPlatform(),
            $keys[14] => $this->getPostData(),
            $keys[15] => $this->getClientUser(),
            $keys[16] => $this->getAdminUser(),
            $keys[17] => $this->getErrorMessage(),
        ];
        if ($result[$keys[1]] instanceof \DateTimeInterface) {
            $result[$keys[1]] = $result[$keys[1]]->format('Y-m-d H:i:s.u');
        }

        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }


        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this
     */
    public function setByName(string $name, $value, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = StatTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        $this->setByPosition($pos, $value);

        return $this;
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return $this
     */
    public function setByPosition(int $pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setDatetime($value);
                break;
            case 2:
                $this->setRemoteAddr($value);
                break;
            case 3:
                $this->setRequestedPage($value);
                break;
            case 4:
                $this->setRequestUri($value);
                break;
            case 5:
                $this->setUserAgent($value);
                break;
            case 6:
                $this->setRequestMethod($value);
                break;
            case 7:
                $this->setReferer($value);
                break;
            case 8:
                $this->setElapsedTime($value);
                break;
            case 9:
                $this->setMemory($value);
                break;
            case 10:
                $this->setClientType($value);
                break;
            case 11:
                $this->setHost($value);
                break;
            case 12:
                $this->setClient($value);
                break;
            case 13:
                $this->setPlatform($value);
                break;
            case 14:
                $this->setPostData($value);
                break;
            case 15:
                $this->setClientUser($value);
                break;
            case 16:
                $this->setAdminUser($value);
                break;
            case 17:
                $this->setErrorMessage($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param array $arr An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return $this
     */
    public function fromArray(array $arr, string $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = StatTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setDatetime($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setRemoteAddr($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setRequestedPage($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setRequestUri($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setUserAgent($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setRequestMethod($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setReferer($arr[$keys[7]]);
        }
        if (array_key_exists($keys[8], $arr)) {
            $this->setElapsedTime($arr[$keys[8]]);
        }
        if (array_key_exists($keys[9], $arr)) {
            $this->setMemory($arr[$keys[9]]);
        }
        if (array_key_exists($keys[10], $arr)) {
            $this->setClientType($arr[$keys[10]]);
        }
        if (array_key_exists($keys[11], $arr)) {
            $this->setHost($arr[$keys[11]]);
        }
        if (array_key_exists($keys[12], $arr)) {
            $this->setClient($arr[$keys[12]]);
        }
        if (array_key_exists($keys[13], $arr)) {
            $this->setPlatform($arr[$keys[13]]);
        }
        if (array_key_exists($keys[14], $arr)) {
            $this->setPostData($arr[$keys[14]]);
        }
        if (array_key_exists($keys[15], $arr)) {
            $this->setClientUser($arr[$keys[15]]);
        }
        if (array_key_exists($keys[16], $arr)) {
            $this->setAdminUser($arr[$keys[16]]);
        }
        if (array_key_exists($keys[17], $arr)) {
            $this->setErrorMessage($arr[$keys[17]]);
        }

        return $this;
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this The current object, for fluid interface
     */
    public function importFrom($parser, string $data, string $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria(): Criteria
    {
        $criteria = new Criteria(StatTableMap::DATABASE_NAME);

        if ($this->isColumnModified(StatTableMap::COL_ID)) {
            $criteria->add(StatTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(StatTableMap::COL_DATETIME)) {
            $criteria->add(StatTableMap::COL_DATETIME, $this->datetime);
        }
        if ($this->isColumnModified(StatTableMap::COL_REMOTE_ADDR)) {
            $criteria->add(StatTableMap::COL_REMOTE_ADDR, $this->remote_addr);
        }
        if ($this->isColumnModified(StatTableMap::COL_REQUESTED_PAGE)) {
            $criteria->add(StatTableMap::COL_REQUESTED_PAGE, $this->requested_page);
        }
        if ($this->isColumnModified(StatTableMap::COL_REQUEST_URI)) {
            $criteria->add(StatTableMap::COL_REQUEST_URI, $this->request_uri);
        }
        if ($this->isColumnModified(StatTableMap::COL_USER_AGENT)) {
            $criteria->add(StatTableMap::COL_USER_AGENT, $this->user_agent);
        }
        if ($this->isColumnModified(StatTableMap::COL_REQUEST_METHOD)) {
            $criteria->add(StatTableMap::COL_REQUEST_METHOD, $this->request_method);
        }
        if ($this->isColumnModified(StatTableMap::COL_REFERER)) {
            $criteria->add(StatTableMap::COL_REFERER, $this->referer);
        }
        if ($this->isColumnModified(StatTableMap::COL_ELAPSED_TIME)) {
            $criteria->add(StatTableMap::COL_ELAPSED_TIME, $this->elapsed_time);
        }
        if ($this->isColumnModified(StatTableMap::COL_MEMORY)) {
            $criteria->add(StatTableMap::COL_MEMORY, $this->memory);
        }
        if ($this->isColumnModified(StatTableMap::COL_CLIENT_TYPE)) {
            $criteria->add(StatTableMap::COL_CLIENT_TYPE, $this->client_type);
        }
        if ($this->isColumnModified(StatTableMap::COL_HOST)) {
            $criteria->add(StatTableMap::COL_HOST, $this->host);
        }
        if ($this->isColumnModified(StatTableMap::COL_CLIENT)) {
            $criteria->add(StatTableMap::COL_CLIENT, $this->client);
        }
        if ($this->isColumnModified(StatTableMap::COL_PLATFORM)) {
            $criteria->add(StatTableMap::COL_PLATFORM, $this->platform);
        }
        if ($this->isColumnModified(StatTableMap::COL_POST_DATA)) {
            $criteria->add(StatTableMap::COL_POST_DATA, $this->post_data);
        }
        if ($this->isColumnModified(StatTableMap::COL_CLIENT_USER)) {
            $criteria->add(StatTableMap::COL_CLIENT_USER, $this->client_user);
        }
        if ($this->isColumnModified(StatTableMap::COL_ADMIN_USER)) {
            $criteria->add(StatTableMap::COL_ADMIN_USER, $this->admin_user);
        }
        if ($this->isColumnModified(StatTableMap::COL_ERROR_MESSAGE)) {
            $criteria->add(StatTableMap::COL_ERROR_MESSAGE, $this->error_message);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria(): Criteria
    {
        $criteria = ChildStatQuery::create();
        $criteria->add(StatTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int|string Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param int|null $key Primary key.
     * @return void
     */
    public function setPrimaryKey(?int $key = null): void
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     *
     * @return bool
     */
    public function isPrimaryKeyNull(): bool
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of \Diamond\Infrastructure\Models\Stat\Stat (or compatible) type.
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param bool $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function copyInto(object $copyObj, bool $deepCopy = false, bool $makeNew = true): void
    {
        $copyObj->setDatetime($this->getDatetime());
        $copyObj->setRemoteAddr($this->getRemoteAddr());
        $copyObj->setRequestedPage($this->getRequestedPage());
        $copyObj->setRequestUri($this->getRequestUri());
        $copyObj->setUserAgent($this->getUserAgent());
        $copyObj->setRequestMethod($this->getRequestMethod());
        $copyObj->setReferer($this->getReferer());
        $copyObj->setElapsedTime($this->getElapsedTime());
        $copyObj->setMemory($this->getMemory());
        $copyObj->setClientType($this->getClientType());
        $copyObj->setHost($this->getHost());
        $copyObj->setClient($this->getClient());
        $copyObj->setPlatform($this->getPlatform());
        $copyObj->setPostData($this->getPostData());
        $copyObj->setClientUser($this->getClientUser());
        $copyObj->setAdminUser($this->getAdminUser());
        $copyObj->setErrorMessage($this->getErrorMessage());
        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Diamond\Infrastructure\Models\Stat\Stat Clone of current object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function copy(bool $deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     *
     * @return $this
     */
    public function clear()
    {
        $this->id = null;
        $this->datetime = null;
        $this->remote_addr = null;
        $this->requested_page = null;
        $this->request_uri = null;
        $this->user_agent = null;
        $this->request_method = null;
        $this->referer = null;
        $this->elapsed_time = null;
        $this->memory = null;
        $this->client_type = null;
        $this->host = null;
        $this->client = null;
        $this->platform = null;
        $this->post_data = null;
        $this->client_user = null;
        $this->admin_user = null;
        $this->error_message = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);

        return $this;
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param bool $deep Whether to also clear the references on all referrer objects.
     * @return $this
     */
    public function clearAllReferences(bool $deep = false)
    {
        if ($deep) {
        } // if ($deep)

        return $this;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(StatTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preSave(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postSave(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before inserting to database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preInsert(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postInsert(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before updating the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preUpdate(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postUpdate(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before deleting the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preDelete(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postDelete(?ConnectionInterface $con = null): void
    {
            }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);
            $inputData = $params[0];
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->importFrom($format, $inputData, $keyType);
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = $params[0] ?? true;
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->exportTo($format, $includeLazyLoadColumns, $keyType);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
