<?php

namespace Diamond\Infrastructure\Models\Rule\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\Rule\Rule as ChildRule;
use Diamond\Infrastructure\Models\Rule\RuleQuery as ChildRuleQuery;
use Diamond\Infrastructure\Models\Rule\Map\RuleTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_rules' table.
 *
 *
 *
 * @method     ChildRuleQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildRuleQuery orderByGroup($order = Criteria::ASC) Order by the group column
 * @method     ChildRuleQuery orderByUser($order = Criteria::ASC) Order by the user column
 * @method     ChildRuleQuery orderByOprId($order = Criteria::ASC) Order by the opr_id column
 * @method     ChildRuleQuery orderByObject($order = Criteria::ASC) Order by the object column
 * @method     ChildRuleQuery orderByObjectId($order = Criteria::ASC) Order by the object_id column
 * @method     ChildRuleQuery orderByRlsAccess($order = Criteria::ASC) Order by the rls_access column
 *
 * @method     ChildRuleQuery groupById() Group by the id column
 * @method     ChildRuleQuery groupByGroup() Group by the group column
 * @method     ChildRuleQuery groupByUser() Group by the user column
 * @method     ChildRuleQuery groupByOprId() Group by the opr_id column
 * @method     ChildRuleQuery groupByObject() Group by the object column
 * @method     ChildRuleQuery groupByObjectId() Group by the object_id column
 * @method     ChildRuleQuery groupByRlsAccess() Group by the rls_access column
 *
 * @method     ChildRuleQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildRuleQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildRuleQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildRuleQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildRuleQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildRuleQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildRule|null findOne(?ConnectionInterface $con = null) Return the first ChildRule matching the query
 * @method     ChildRule findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildRule matching the query, or a new ChildRule object populated from the query conditions when no match is found
 *
 * @method     ChildRule|null findOneById(int $id) Return the first ChildRule filtered by the id column
 * @method     ChildRule|null findOneByGroup(string $group) Return the first ChildRule filtered by the group column
 * @method     ChildRule|null findOneByUser(string $user) Return the first ChildRule filtered by the user column
 * @method     ChildRule|null findOneByOprId(int $opr_id) Return the first ChildRule filtered by the opr_id column
 * @method     ChildRule|null findOneByObject(string $object) Return the first ChildRule filtered by the object column
 * @method     ChildRule|null findOneByObjectId(string $object_id) Return the first ChildRule filtered by the object_id column
 * @method     ChildRule|null findOneByRlsAccess(string $rls_access) Return the first ChildRule filtered by the rls_access column *

 * @method     ChildRule requirePk($key, ?ConnectionInterface $con = null) Return the ChildRule by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildRule requireOne(?ConnectionInterface $con = null) Return the first ChildRule matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildRule requireOneById(int $id) Return the first ChildRule filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildRule requireOneByGroup(string $group) Return the first ChildRule filtered by the group column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildRule requireOneByUser(string $user) Return the first ChildRule filtered by the user column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildRule requireOneByOprId(int $opr_id) Return the first ChildRule filtered by the opr_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildRule requireOneByObject(string $object) Return the first ChildRule filtered by the object column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildRule requireOneByObjectId(string $object_id) Return the first ChildRule filtered by the object_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildRule requireOneByRlsAccess(string $rls_access) Return the first ChildRule filtered by the rls_access column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildRule[]|Collection find(?ConnectionInterface $con = null) Return ChildRule objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildRule> find(?ConnectionInterface $con = null) Return ChildRule objects based on current ModelCriteria
 * @method     ChildRule[]|Collection findById(int $id) Return ChildRule objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildRule> findById(int $id) Return ChildRule objects filtered by the id column
 * @method     ChildRule[]|Collection findByGroup(string $group) Return ChildRule objects filtered by the group column
 * @psalm-method Collection&\Traversable<ChildRule> findByGroup(string $group) Return ChildRule objects filtered by the group column
 * @method     ChildRule[]|Collection findByUser(string $user) Return ChildRule objects filtered by the user column
 * @psalm-method Collection&\Traversable<ChildRule> findByUser(string $user) Return ChildRule objects filtered by the user column
 * @method     ChildRule[]|Collection findByOprId(int $opr_id) Return ChildRule objects filtered by the opr_id column
 * @psalm-method Collection&\Traversable<ChildRule> findByOprId(int $opr_id) Return ChildRule objects filtered by the opr_id column
 * @method     ChildRule[]|Collection findByObject(string $object) Return ChildRule objects filtered by the object column
 * @psalm-method Collection&\Traversable<ChildRule> findByObject(string $object) Return ChildRule objects filtered by the object column
 * @method     ChildRule[]|Collection findByObjectId(string $object_id) Return ChildRule objects filtered by the object_id column
 * @psalm-method Collection&\Traversable<ChildRule> findByObjectId(string $object_id) Return ChildRule objects filtered by the object_id column
 * @method     ChildRule[]|Collection findByRlsAccess(string $rls_access) Return ChildRule objects filtered by the rls_access column
 * @psalm-method Collection&\Traversable<ChildRule> findByRlsAccess(string $rls_access) Return ChildRule objects filtered by the rls_access column
 * @method     ChildRule[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildRule> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class RuleQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Infrastructure\Models\Rule\Base\RuleQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Infrastructure\\Models\\Rule\\Rule', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildRuleQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildRuleQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildRuleQuery) {
            return $criteria;
        }
        $query = new ChildRuleQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildRule|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(RuleTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = RuleTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildRule A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `group`, `user`, `opr_id`, `object`, `object_id`, `rls_access` FROM `_rules` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildRule $obj */
            $obj = new ChildRule();
            $obj->hydrate($row);
            RuleTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildRule|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(RuleTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(RuleTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(RuleTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(RuleTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(RuleTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the group column
     *
     * Example usage:
     * <code>
     * $query->filterByGroup('fooValue');   // WHERE group = 'fooValue'
     * $query->filterByGroup('%fooValue%', Criteria::LIKE); // WHERE group LIKE '%fooValue%'
     * $query->filterByGroup(['foo', 'bar']); // WHERE group IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $group The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByGroup($group = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($group)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(RuleTableMap::COL_GROUP, $group, $comparison);

        return $this;
    }

    /**
     * Filter the query on the user column
     *
     * Example usage:
     * <code>
     * $query->filterByUser('fooValue');   // WHERE user = 'fooValue'
     * $query->filterByUser('%fooValue%', Criteria::LIKE); // WHERE user LIKE '%fooValue%'
     * $query->filterByUser(['foo', 'bar']); // WHERE user IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $user The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByUser($user = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($user)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(RuleTableMap::COL_USER, $user, $comparison);

        return $this;
    }

    /**
     * Filter the query on the opr_id column
     *
     * Example usage:
     * <code>
     * $query->filterByOprId(1234); // WHERE opr_id = 1234
     * $query->filterByOprId(array(12, 34)); // WHERE opr_id IN (12, 34)
     * $query->filterByOprId(array('min' => 12)); // WHERE opr_id > 12
     * </code>
     *
     * @param mixed $oprId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByOprId($oprId = null, ?string $comparison = null)
    {
        if (is_array($oprId)) {
            $useMinMax = false;
            if (isset($oprId['min'])) {
                $this->addUsingAlias(RuleTableMap::COL_OPR_ID, $oprId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($oprId['max'])) {
                $this->addUsingAlias(RuleTableMap::COL_OPR_ID, $oprId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(RuleTableMap::COL_OPR_ID, $oprId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the object column
     *
     * Example usage:
     * <code>
     * $query->filterByObject('fooValue');   // WHERE object = 'fooValue'
     * $query->filterByObject('%fooValue%', Criteria::LIKE); // WHERE object LIKE '%fooValue%'
     * $query->filterByObject(['foo', 'bar']); // WHERE object IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $object The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByObject($object = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($object)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(RuleTableMap::COL_OBJECT, $object, $comparison);

        return $this;
    }

    /**
     * Filter the query on the object_id column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectId('fooValue');   // WHERE object_id = 'fooValue'
     * $query->filterByObjectId('%fooValue%', Criteria::LIKE); // WHERE object_id LIKE '%fooValue%'
     * $query->filterByObjectId(['foo', 'bar']); // WHERE object_id IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $objectId The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByObjectId($objectId = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($objectId)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(RuleTableMap::COL_OBJECT_ID, $objectId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the rls_access column
     *
     * Example usage:
     * <code>
     * $query->filterByRlsAccess('fooValue');   // WHERE rls_access = 'fooValue'
     * $query->filterByRlsAccess('%fooValue%', Criteria::LIKE); // WHERE rls_access LIKE '%fooValue%'
     * $query->filterByRlsAccess(['foo', 'bar']); // WHERE rls_access IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $rlsAccess The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByRlsAccess($rlsAccess = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($rlsAccess)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(RuleTableMap::COL_RLS_ACCESS, $rlsAccess, $comparison);

        return $this;
    }

    /**
     * Exclude object from result
     *
     * @param ChildRule $rule Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($rule = null)
    {
        if ($rule) {
            $this->addUsingAlias(RuleTableMap::COL_ID, $rule->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _rules table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(RuleTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            RuleTableMap::clearInstancePool();
            RuleTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(RuleTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(RuleTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            RuleTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            RuleTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
