<?php

namespace Diamond\Infrastructure\Models\MailingRequest\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\Mailing\Mailing;
use Diamond\Infrastructure\Models\MailingRequest\MailingRequest as ChildMailingRequest;
use Diamond\Infrastructure\Models\MailingRequest\MailingRequestQuery as ChildMailingRequestQuery;
use Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipient;
use Diamond\Infrastructure\Models\MailingRequest\Map\MailingRequestTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_mailing_requests' table.
 *
 *
 *
 * @method     ChildMailingRequestQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildMailingRequestQuery orderByMailingId($order = Criteria::ASC) Order by the mailing_id column
 * @method     ChildMailingRequestQuery orderBySubject($order = Criteria::ASC) Order by the subject column
 * @method     ChildMailingRequestQuery orderByBody($order = Criteria::ASC) Order by the body column
 * @method     ChildMailingRequestQuery orderByCreatedAt($order = Criteria::ASC) Order by the created_at column
 * @method     ChildMailingRequestQuery orderByCompleted($order = Criteria::ASC) Order by the completed column
 *
 * @method     ChildMailingRequestQuery groupById() Group by the id column
 * @method     ChildMailingRequestQuery groupByMailingId() Group by the mailing_id column
 * @method     ChildMailingRequestQuery groupBySubject() Group by the subject column
 * @method     ChildMailingRequestQuery groupByBody() Group by the body column
 * @method     ChildMailingRequestQuery groupByCreatedAt() Group by the created_at column
 * @method     ChildMailingRequestQuery groupByCompleted() Group by the completed column
 *
 * @method     ChildMailingRequestQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildMailingRequestQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildMailingRequestQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildMailingRequestQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildMailingRequestQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildMailingRequestQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildMailingRequestQuery leftJoinMailing($relationAlias = null) Adds a LEFT JOIN clause to the query using the Mailing relation
 * @method     ChildMailingRequestQuery rightJoinMailing($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Mailing relation
 * @method     ChildMailingRequestQuery innerJoinMailing($relationAlias = null) Adds a INNER JOIN clause to the query using the Mailing relation
 *
 * @method     ChildMailingRequestQuery joinWithMailing($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Mailing relation
 *
 * @method     ChildMailingRequestQuery leftJoinWithMailing() Adds a LEFT JOIN clause and with to the query using the Mailing relation
 * @method     ChildMailingRequestQuery rightJoinWithMailing() Adds a RIGHT JOIN clause and with to the query using the Mailing relation
 * @method     ChildMailingRequestQuery innerJoinWithMailing() Adds a INNER JOIN clause and with to the query using the Mailing relation
 *
 * @method     ChildMailingRequestQuery leftJoinMailingRequestRecipient($relationAlias = null) Adds a LEFT JOIN clause to the query using the MailingRequestRecipient relation
 * @method     ChildMailingRequestQuery rightJoinMailingRequestRecipient($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MailingRequestRecipient relation
 * @method     ChildMailingRequestQuery innerJoinMailingRequestRecipient($relationAlias = null) Adds a INNER JOIN clause to the query using the MailingRequestRecipient relation
 *
 * @method     ChildMailingRequestQuery joinWithMailingRequestRecipient($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the MailingRequestRecipient relation
 *
 * @method     ChildMailingRequestQuery leftJoinWithMailingRequestRecipient() Adds a LEFT JOIN clause and with to the query using the MailingRequestRecipient relation
 * @method     ChildMailingRequestQuery rightJoinWithMailingRequestRecipient() Adds a RIGHT JOIN clause and with to the query using the MailingRequestRecipient relation
 * @method     ChildMailingRequestQuery innerJoinWithMailingRequestRecipient() Adds a INNER JOIN clause and with to the query using the MailingRequestRecipient relation
 *
 * @method     \Diamond\Infrastructure\Models\Mailing\MailingQuery|\Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipientQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildMailingRequest|null findOne(?ConnectionInterface $con = null) Return the first ChildMailingRequest matching the query
 * @method     ChildMailingRequest findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildMailingRequest matching the query, or a new ChildMailingRequest object populated from the query conditions when no match is found
 *
 * @method     ChildMailingRequest|null findOneById(int $id) Return the first ChildMailingRequest filtered by the id column
 * @method     ChildMailingRequest|null findOneByMailingId(int $mailing_id) Return the first ChildMailingRequest filtered by the mailing_id column
 * @method     ChildMailingRequest|null findOneBySubject(string $subject) Return the first ChildMailingRequest filtered by the subject column
 * @method     ChildMailingRequest|null findOneByBody(string $body) Return the first ChildMailingRequest filtered by the body column
 * @method     ChildMailingRequest|null findOneByCreatedAt(string $created_at) Return the first ChildMailingRequest filtered by the created_at column
 * @method     ChildMailingRequest|null findOneByCompleted(int $completed) Return the first ChildMailingRequest filtered by the completed column *

 * @method     ChildMailingRequest requirePk($key, ?ConnectionInterface $con = null) Return the ChildMailingRequest by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingRequest requireOne(?ConnectionInterface $con = null) Return the first ChildMailingRequest matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildMailingRequest requireOneById(int $id) Return the first ChildMailingRequest filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingRequest requireOneByMailingId(int $mailing_id) Return the first ChildMailingRequest filtered by the mailing_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingRequest requireOneBySubject(string $subject) Return the first ChildMailingRequest filtered by the subject column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingRequest requireOneByBody(string $body) Return the first ChildMailingRequest filtered by the body column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingRequest requireOneByCreatedAt(string $created_at) Return the first ChildMailingRequest filtered by the created_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingRequest requireOneByCompleted(int $completed) Return the first ChildMailingRequest filtered by the completed column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildMailingRequest[]|Collection find(?ConnectionInterface $con = null) Return ChildMailingRequest objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildMailingRequest> find(?ConnectionInterface $con = null) Return ChildMailingRequest objects based on current ModelCriteria
 * @method     ChildMailingRequest[]|Collection findById(int $id) Return ChildMailingRequest objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildMailingRequest> findById(int $id) Return ChildMailingRequest objects filtered by the id column
 * @method     ChildMailingRequest[]|Collection findByMailingId(int $mailing_id) Return ChildMailingRequest objects filtered by the mailing_id column
 * @psalm-method Collection&\Traversable<ChildMailingRequest> findByMailingId(int $mailing_id) Return ChildMailingRequest objects filtered by the mailing_id column
 * @method     ChildMailingRequest[]|Collection findBySubject(string $subject) Return ChildMailingRequest objects filtered by the subject column
 * @psalm-method Collection&\Traversable<ChildMailingRequest> findBySubject(string $subject) Return ChildMailingRequest objects filtered by the subject column
 * @method     ChildMailingRequest[]|Collection findByBody(string $body) Return ChildMailingRequest objects filtered by the body column
 * @psalm-method Collection&\Traversable<ChildMailingRequest> findByBody(string $body) Return ChildMailingRequest objects filtered by the body column
 * @method     ChildMailingRequest[]|Collection findByCreatedAt(string $created_at) Return ChildMailingRequest objects filtered by the created_at column
 * @psalm-method Collection&\Traversable<ChildMailingRequest> findByCreatedAt(string $created_at) Return ChildMailingRequest objects filtered by the created_at column
 * @method     ChildMailingRequest[]|Collection findByCompleted(int $completed) Return ChildMailingRequest objects filtered by the completed column
 * @psalm-method Collection&\Traversable<ChildMailingRequest> findByCompleted(int $completed) Return ChildMailingRequest objects filtered by the completed column
 * @method     ChildMailingRequest[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildMailingRequest> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class MailingRequestQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Infrastructure\Models\MailingRequest\Base\MailingRequestQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Infrastructure\\Models\\MailingRequest\\MailingRequest', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildMailingRequestQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildMailingRequestQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildMailingRequestQuery) {
            return $criteria;
        }
        $query = new ChildMailingRequestQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildMailingRequest|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(MailingRequestTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = MailingRequestTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildMailingRequest A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `mailing_id`, `subject`, `body`, `created_at`, `completed` FROM `_mailing_requests` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildMailingRequest $obj */
            $obj = new ChildMailingRequest();
            $obj->hydrate($row);
            MailingRequestTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildMailingRequest|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(MailingRequestTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(MailingRequestTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(MailingRequestTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(MailingRequestTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingRequestTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the mailing_id column
     *
     * Example usage:
     * <code>
     * $query->filterByMailingId(1234); // WHERE mailing_id = 1234
     * $query->filterByMailingId(array(12, 34)); // WHERE mailing_id IN (12, 34)
     * $query->filterByMailingId(array('min' => 12)); // WHERE mailing_id > 12
     * </code>
     *
     * @see       filterByMailing()
     *
     * @param mixed $mailingId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByMailingId($mailingId = null, ?string $comparison = null)
    {
        if (is_array($mailingId)) {
            $useMinMax = false;
            if (isset($mailingId['min'])) {
                $this->addUsingAlias(MailingRequestTableMap::COL_MAILING_ID, $mailingId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($mailingId['max'])) {
                $this->addUsingAlias(MailingRequestTableMap::COL_MAILING_ID, $mailingId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingRequestTableMap::COL_MAILING_ID, $mailingId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the subject column
     *
     * Example usage:
     * <code>
     * $query->filterBySubject('fooValue');   // WHERE subject = 'fooValue'
     * $query->filterBySubject('%fooValue%', Criteria::LIKE); // WHERE subject LIKE '%fooValue%'
     * $query->filterBySubject(['foo', 'bar']); // WHERE subject IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $subject The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterBySubject($subject = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($subject)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingRequestTableMap::COL_SUBJECT, $subject, $comparison);

        return $this;
    }

    /**
     * Filter the query on the body column
     *
     * Example usage:
     * <code>
     * $query->filterByBody('fooValue');   // WHERE body = 'fooValue'
     * $query->filterByBody('%fooValue%', Criteria::LIKE); // WHERE body LIKE '%fooValue%'
     * $query->filterByBody(['foo', 'bar']); // WHERE body IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $body The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByBody($body = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($body)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingRequestTableMap::COL_BODY, $body, $comparison);

        return $this;
    }

    /**
     * Filter the query on the created_at column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatedAt('2011-03-14'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt('now'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt(array('max' => 'yesterday')); // WHERE created_at > '2011-03-13'
     * </code>
     *
     * @param mixed $createdAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCreatedAt($createdAt = null, ?string $comparison = null)
    {
        if (is_array($createdAt)) {
            $useMinMax = false;
            if (isset($createdAt['min'])) {
                $this->addUsingAlias(MailingRequestTableMap::COL_CREATED_AT, $createdAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($createdAt['max'])) {
                $this->addUsingAlias(MailingRequestTableMap::COL_CREATED_AT, $createdAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingRequestTableMap::COL_CREATED_AT, $createdAt, $comparison);

        return $this;
    }

    /**
     * Filter the query on the completed column
     *
     * Example usage:
     * <code>
     * $query->filterByCompleted(1234); // WHERE completed = 1234
     * $query->filterByCompleted(array(12, 34)); // WHERE completed IN (12, 34)
     * $query->filterByCompleted(array('min' => 12)); // WHERE completed > 12
     * </code>
     *
     * @param mixed $completed The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCompleted($completed = null, ?string $comparison = null)
    {
        if (is_array($completed)) {
            $useMinMax = false;
            if (isset($completed['min'])) {
                $this->addUsingAlias(MailingRequestTableMap::COL_COMPLETED, $completed['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($completed['max'])) {
                $this->addUsingAlias(MailingRequestTableMap::COL_COMPLETED, $completed['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingRequestTableMap::COL_COMPLETED, $completed, $comparison);

        return $this;
    }

    /**
     * Filter the query by a related \Diamond\Infrastructure\Models\Mailing\Mailing object
     *
     * @param \Diamond\Infrastructure\Models\Mailing\Mailing|ObjectCollection $mailing The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByMailing($mailing, ?string $comparison = null)
    {
        if ($mailing instanceof \Diamond\Infrastructure\Models\Mailing\Mailing) {
            return $this
                ->addUsingAlias(MailingRequestTableMap::COL_MAILING_ID, $mailing->getId(), $comparison);
        } elseif ($mailing instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(MailingRequestTableMap::COL_MAILING_ID, $mailing->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByMailing() only accepts arguments of type \Diamond\Infrastructure\Models\Mailing\Mailing or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Mailing relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinMailing(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Mailing');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Mailing');
        }

        return $this;
    }

    /**
     * Use the Mailing relation Mailing object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Infrastructure\Models\Mailing\MailingQuery A secondary query class using the current class as primary query
     */
    public function useMailingQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMailing($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Mailing', '\Diamond\Infrastructure\Models\Mailing\MailingQuery');
    }

    /**
     * Use the Mailing relation Mailing object
     *
     * @param callable(\Diamond\Infrastructure\Models\Mailing\MailingQuery):\Diamond\Infrastructure\Models\Mailing\MailingQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withMailingQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useMailingQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Mailing table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Diamond\Infrastructure\Models\Mailing\MailingQuery The inner query object of the EXISTS statement
     */
    public function useMailingExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Mailing', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Mailing table for a NOT EXISTS query.
     *
     * @see useMailingExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Diamond\Infrastructure\Models\Mailing\MailingQuery The inner query object of the NOT EXISTS statement
     */
    public function useMailingNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Mailing', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipient object
     *
     * @param \Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipient|ObjectCollection $mailingRequestRecipient the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByMailingRequestRecipient($mailingRequestRecipient, ?string $comparison = null)
    {
        if ($mailingRequestRecipient instanceof \Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipient) {
            $this
                ->addUsingAlias(MailingRequestTableMap::COL_ID, $mailingRequestRecipient->getRequestId(), $comparison);

            return $this;
        } elseif ($mailingRequestRecipient instanceof ObjectCollection) {
            $this
                ->useMailingRequestRecipientQuery()
                ->filterByPrimaryKeys($mailingRequestRecipient->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByMailingRequestRecipient() only accepts arguments of type \Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipient or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MailingRequestRecipient relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinMailingRequestRecipient(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MailingRequestRecipient');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MailingRequestRecipient');
        }

        return $this;
    }

    /**
     * Use the MailingRequestRecipient relation MailingRequestRecipient object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipientQuery A secondary query class using the current class as primary query
     */
    public function useMailingRequestRecipientQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMailingRequestRecipient($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MailingRequestRecipient', '\Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipientQuery');
    }

    /**
     * Use the MailingRequestRecipient relation MailingRequestRecipient object
     *
     * @param callable(\Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipientQuery):\Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipientQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withMailingRequestRecipientQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useMailingRequestRecipientQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to MailingRequestRecipient table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipientQuery The inner query object of the EXISTS statement
     */
    public function useMailingRequestRecipientExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('MailingRequestRecipient', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to MailingRequestRecipient table for a NOT EXISTS query.
     *
     * @see useMailingRequestRecipientExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipientQuery The inner query object of the NOT EXISTS statement
     */
    public function useMailingRequestRecipientNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('MailingRequestRecipient', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Exclude object from result
     *
     * @param ChildMailingRequest $mailingRequest Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($mailingRequest = null)
    {
        if ($mailingRequest) {
            $this->addUsingAlias(MailingRequestTableMap::COL_ID, $mailingRequest->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _mailing_requests table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MailingRequestTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            MailingRequestTableMap::clearInstancePool();
            MailingRequestTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MailingRequestTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(MailingRequestTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            MailingRequestTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            MailingRequestTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
