<?php

namespace Diamond\Infrastructure\Models\GuestBookItem\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\GuestBook\GuestBook;
use Diamond\Infrastructure\Models\GuestBookItem\GuestBookItem as ChildGuestBookItem;
use Diamond\Infrastructure\Models\GuestBookItem\GuestBookItemQuery as ChildGuestBookItemQuery;
use Diamond\Infrastructure\Models\GuestBookItem\Map\GuestBookItemTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_guest_book_items' table.
 *
 *
 *
 * @method     ChildGuestBookItemQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildGuestBookItemQuery orderByText($order = Criteria::ASC) Order by the text column
 * @method     ChildGuestBookItemQuery orderByDate($order = Criteria::ASC) Order by the date column
 * @method     ChildGuestBookItemQuery orderByIp($order = Criteria::ASC) Order by the ip column
 * @method     ChildGuestBookItemQuery orderByPublished($order = Criteria::ASC) Order by the published column
 * @method     ChildGuestBookItemQuery orderByUsername($order = Criteria::ASC) Order by the username column
 * @method     ChildGuestBookItemQuery orderByUseremail($order = Criteria::ASC) Order by the useremail column
 * @method     ChildGuestBookItemQuery orderByBookId($order = Criteria::ASC) Order by the book_id column
 * @method     ChildGuestBookItemQuery orderByObjectId($order = Criteria::ASC) Order by the object_id column
 * @method     ChildGuestBookItemQuery orderByRank($order = Criteria::ASC) Order by the rank column
 *
 * @method     ChildGuestBookItemQuery groupById() Group by the id column
 * @method     ChildGuestBookItemQuery groupByText() Group by the text column
 * @method     ChildGuestBookItemQuery groupByDate() Group by the date column
 * @method     ChildGuestBookItemQuery groupByIp() Group by the ip column
 * @method     ChildGuestBookItemQuery groupByPublished() Group by the published column
 * @method     ChildGuestBookItemQuery groupByUsername() Group by the username column
 * @method     ChildGuestBookItemQuery groupByUseremail() Group by the useremail column
 * @method     ChildGuestBookItemQuery groupByBookId() Group by the book_id column
 * @method     ChildGuestBookItemQuery groupByObjectId() Group by the object_id column
 * @method     ChildGuestBookItemQuery groupByRank() Group by the rank column
 *
 * @method     ChildGuestBookItemQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildGuestBookItemQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildGuestBookItemQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildGuestBookItemQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildGuestBookItemQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildGuestBookItemQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildGuestBookItemQuery leftJoinGuestBook($relationAlias = null) Adds a LEFT JOIN clause to the query using the GuestBook relation
 * @method     ChildGuestBookItemQuery rightJoinGuestBook($relationAlias = null) Adds a RIGHT JOIN clause to the query using the GuestBook relation
 * @method     ChildGuestBookItemQuery innerJoinGuestBook($relationAlias = null) Adds a INNER JOIN clause to the query using the GuestBook relation
 *
 * @method     ChildGuestBookItemQuery joinWithGuestBook($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the GuestBook relation
 *
 * @method     ChildGuestBookItemQuery leftJoinWithGuestBook() Adds a LEFT JOIN clause and with to the query using the GuestBook relation
 * @method     ChildGuestBookItemQuery rightJoinWithGuestBook() Adds a RIGHT JOIN clause and with to the query using the GuestBook relation
 * @method     ChildGuestBookItemQuery innerJoinWithGuestBook() Adds a INNER JOIN clause and with to the query using the GuestBook relation
 *
 * @method     \Diamond\Infrastructure\Models\GuestBook\GuestBookQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildGuestBookItem|null findOne(?ConnectionInterface $con = null) Return the first ChildGuestBookItem matching the query
 * @method     ChildGuestBookItem findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildGuestBookItem matching the query, or a new ChildGuestBookItem object populated from the query conditions when no match is found
 *
 * @method     ChildGuestBookItem|null findOneById(int $id) Return the first ChildGuestBookItem filtered by the id column
 * @method     ChildGuestBookItem|null findOneByText(string $text) Return the first ChildGuestBookItem filtered by the text column
 * @method     ChildGuestBookItem|null findOneByDate(string $date) Return the first ChildGuestBookItem filtered by the date column
 * @method     ChildGuestBookItem|null findOneByIp(string $ip) Return the first ChildGuestBookItem filtered by the ip column
 * @method     ChildGuestBookItem|null findOneByPublished(string $published) Return the first ChildGuestBookItem filtered by the published column
 * @method     ChildGuestBookItem|null findOneByUsername(string $username) Return the first ChildGuestBookItem filtered by the username column
 * @method     ChildGuestBookItem|null findOneByUseremail(string $useremail) Return the first ChildGuestBookItem filtered by the useremail column
 * @method     ChildGuestBookItem|null findOneByBookId(int $book_id) Return the first ChildGuestBookItem filtered by the book_id column
 * @method     ChildGuestBookItem|null findOneByObjectId(string $object_id) Return the first ChildGuestBookItem filtered by the object_id column
 * @method     ChildGuestBookItem|null findOneByRank(int $rank) Return the first ChildGuestBookItem filtered by the rank column *

 * @method     ChildGuestBookItem requirePk($key, ?ConnectionInterface $con = null) Return the ChildGuestBookItem by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGuestBookItem requireOne(?ConnectionInterface $con = null) Return the first ChildGuestBookItem matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildGuestBookItem requireOneById(int $id) Return the first ChildGuestBookItem filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGuestBookItem requireOneByText(string $text) Return the first ChildGuestBookItem filtered by the text column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGuestBookItem requireOneByDate(string $date) Return the first ChildGuestBookItem filtered by the date column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGuestBookItem requireOneByIp(string $ip) Return the first ChildGuestBookItem filtered by the ip column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGuestBookItem requireOneByPublished(string $published) Return the first ChildGuestBookItem filtered by the published column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGuestBookItem requireOneByUsername(string $username) Return the first ChildGuestBookItem filtered by the username column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGuestBookItem requireOneByUseremail(string $useremail) Return the first ChildGuestBookItem filtered by the useremail column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGuestBookItem requireOneByBookId(int $book_id) Return the first ChildGuestBookItem filtered by the book_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGuestBookItem requireOneByObjectId(string $object_id) Return the first ChildGuestBookItem filtered by the object_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGuestBookItem requireOneByRank(int $rank) Return the first ChildGuestBookItem filtered by the rank column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildGuestBookItem[]|Collection find(?ConnectionInterface $con = null) Return ChildGuestBookItem objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildGuestBookItem> find(?ConnectionInterface $con = null) Return ChildGuestBookItem objects based on current ModelCriteria
 * @method     ChildGuestBookItem[]|Collection findById(int $id) Return ChildGuestBookItem objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildGuestBookItem> findById(int $id) Return ChildGuestBookItem objects filtered by the id column
 * @method     ChildGuestBookItem[]|Collection findByText(string $text) Return ChildGuestBookItem objects filtered by the text column
 * @psalm-method Collection&\Traversable<ChildGuestBookItem> findByText(string $text) Return ChildGuestBookItem objects filtered by the text column
 * @method     ChildGuestBookItem[]|Collection findByDate(string $date) Return ChildGuestBookItem objects filtered by the date column
 * @psalm-method Collection&\Traversable<ChildGuestBookItem> findByDate(string $date) Return ChildGuestBookItem objects filtered by the date column
 * @method     ChildGuestBookItem[]|Collection findByIp(string $ip) Return ChildGuestBookItem objects filtered by the ip column
 * @psalm-method Collection&\Traversable<ChildGuestBookItem> findByIp(string $ip) Return ChildGuestBookItem objects filtered by the ip column
 * @method     ChildGuestBookItem[]|Collection findByPublished(string $published) Return ChildGuestBookItem objects filtered by the published column
 * @psalm-method Collection&\Traversable<ChildGuestBookItem> findByPublished(string $published) Return ChildGuestBookItem objects filtered by the published column
 * @method     ChildGuestBookItem[]|Collection findByUsername(string $username) Return ChildGuestBookItem objects filtered by the username column
 * @psalm-method Collection&\Traversable<ChildGuestBookItem> findByUsername(string $username) Return ChildGuestBookItem objects filtered by the username column
 * @method     ChildGuestBookItem[]|Collection findByUseremail(string $useremail) Return ChildGuestBookItem objects filtered by the useremail column
 * @psalm-method Collection&\Traversable<ChildGuestBookItem> findByUseremail(string $useremail) Return ChildGuestBookItem objects filtered by the useremail column
 * @method     ChildGuestBookItem[]|Collection findByBookId(int $book_id) Return ChildGuestBookItem objects filtered by the book_id column
 * @psalm-method Collection&\Traversable<ChildGuestBookItem> findByBookId(int $book_id) Return ChildGuestBookItem objects filtered by the book_id column
 * @method     ChildGuestBookItem[]|Collection findByObjectId(string $object_id) Return ChildGuestBookItem objects filtered by the object_id column
 * @psalm-method Collection&\Traversable<ChildGuestBookItem> findByObjectId(string $object_id) Return ChildGuestBookItem objects filtered by the object_id column
 * @method     ChildGuestBookItem[]|Collection findByRank(int $rank) Return ChildGuestBookItem objects filtered by the rank column
 * @psalm-method Collection&\Traversable<ChildGuestBookItem> findByRank(int $rank) Return ChildGuestBookItem objects filtered by the rank column
 * @method     ChildGuestBookItem[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildGuestBookItem> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class GuestBookItemQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Infrastructure\Models\GuestBookItem\Base\GuestBookItemQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Infrastructure\\Models\\GuestBookItem\\GuestBookItem', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildGuestBookItemQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildGuestBookItemQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildGuestBookItemQuery) {
            return $criteria;
        }
        $query = new ChildGuestBookItemQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildGuestBookItem|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(GuestBookItemTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = GuestBookItemTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildGuestBookItem A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `text`, `date`, `ip`, `published`, `username`, `useremail`, `book_id`, `object_id`, `rank` FROM `_guest_book_items` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildGuestBookItem $obj */
            $obj = new ChildGuestBookItem();
            $obj->hydrate($row);
            GuestBookItemTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildGuestBookItem|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(GuestBookItemTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(GuestBookItemTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(GuestBookItemTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(GuestBookItemTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(GuestBookItemTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the text column
     *
     * Example usage:
     * <code>
     * $query->filterByText('fooValue');   // WHERE text = 'fooValue'
     * $query->filterByText('%fooValue%', Criteria::LIKE); // WHERE text LIKE '%fooValue%'
     * $query->filterByText(['foo', 'bar']); // WHERE text IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $text The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByText($text = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($text)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(GuestBookItemTableMap::COL_TEXT, $text, $comparison);

        return $this;
    }

    /**
     * Filter the query on the date column
     *
     * Example usage:
     * <code>
     * $query->filterByDate('2011-03-14'); // WHERE date = '2011-03-14'
     * $query->filterByDate('now'); // WHERE date = '2011-03-14'
     * $query->filterByDate(array('max' => 'yesterday')); // WHERE date > '2011-03-13'
     * </code>
     *
     * @param mixed $date The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDate($date = null, ?string $comparison = null)
    {
        if (is_array($date)) {
            $useMinMax = false;
            if (isset($date['min'])) {
                $this->addUsingAlias(GuestBookItemTableMap::COL_DATE, $date['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($date['max'])) {
                $this->addUsingAlias(GuestBookItemTableMap::COL_DATE, $date['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(GuestBookItemTableMap::COL_DATE, $date, $comparison);

        return $this;
    }

    /**
     * Filter the query on the ip column
     *
     * Example usage:
     * <code>
     * $query->filterByIp('fooValue');   // WHERE ip = 'fooValue'
     * $query->filterByIp('%fooValue%', Criteria::LIKE); // WHERE ip LIKE '%fooValue%'
     * $query->filterByIp(['foo', 'bar']); // WHERE ip IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $ip The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByIp($ip = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($ip)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(GuestBookItemTableMap::COL_IP, $ip, $comparison);

        return $this;
    }

    /**
     * Filter the query on the published column
     *
     * Example usage:
     * <code>
     * $query->filterByPublished('fooValue');   // WHERE published = 'fooValue'
     * $query->filterByPublished('%fooValue%', Criteria::LIKE); // WHERE published LIKE '%fooValue%'
     * $query->filterByPublished(['foo', 'bar']); // WHERE published IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $published The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPublished($published = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($published)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(GuestBookItemTableMap::COL_PUBLISHED, $published, $comparison);

        return $this;
    }

    /**
     * Filter the query on the username column
     *
     * Example usage:
     * <code>
     * $query->filterByUsername('fooValue');   // WHERE username = 'fooValue'
     * $query->filterByUsername('%fooValue%', Criteria::LIKE); // WHERE username LIKE '%fooValue%'
     * $query->filterByUsername(['foo', 'bar']); // WHERE username IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $username The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByUsername($username = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($username)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(GuestBookItemTableMap::COL_USERNAME, $username, $comparison);

        return $this;
    }

    /**
     * Filter the query on the useremail column
     *
     * Example usage:
     * <code>
     * $query->filterByUseremail('fooValue');   // WHERE useremail = 'fooValue'
     * $query->filterByUseremail('%fooValue%', Criteria::LIKE); // WHERE useremail LIKE '%fooValue%'
     * $query->filterByUseremail(['foo', 'bar']); // WHERE useremail IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $useremail The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByUseremail($useremail = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($useremail)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(GuestBookItemTableMap::COL_USEREMAIL, $useremail, $comparison);

        return $this;
    }

    /**
     * Filter the query on the book_id column
     *
     * Example usage:
     * <code>
     * $query->filterByBookId(1234); // WHERE book_id = 1234
     * $query->filterByBookId(array(12, 34)); // WHERE book_id IN (12, 34)
     * $query->filterByBookId(array('min' => 12)); // WHERE book_id > 12
     * </code>
     *
     * @see       filterByGuestBook()
     *
     * @param mixed $bookId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByBookId($bookId = null, ?string $comparison = null)
    {
        if (is_array($bookId)) {
            $useMinMax = false;
            if (isset($bookId['min'])) {
                $this->addUsingAlias(GuestBookItemTableMap::COL_BOOK_ID, $bookId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($bookId['max'])) {
                $this->addUsingAlias(GuestBookItemTableMap::COL_BOOK_ID, $bookId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(GuestBookItemTableMap::COL_BOOK_ID, $bookId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the object_id column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectId('fooValue');   // WHERE object_id = 'fooValue'
     * $query->filterByObjectId('%fooValue%', Criteria::LIKE); // WHERE object_id LIKE '%fooValue%'
     * $query->filterByObjectId(['foo', 'bar']); // WHERE object_id IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $objectId The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByObjectId($objectId = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($objectId)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(GuestBookItemTableMap::COL_OBJECT_ID, $objectId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the rank column
     *
     * Example usage:
     * <code>
     * $query->filterByRank(1234); // WHERE rank = 1234
     * $query->filterByRank(array(12, 34)); // WHERE rank IN (12, 34)
     * $query->filterByRank(array('min' => 12)); // WHERE rank > 12
     * </code>
     *
     * @param mixed $rank The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByRank($rank = null, ?string $comparison = null)
    {
        if (is_array($rank)) {
            $useMinMax = false;
            if (isset($rank['min'])) {
                $this->addUsingAlias(GuestBookItemTableMap::COL_RANK, $rank['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($rank['max'])) {
                $this->addUsingAlias(GuestBookItemTableMap::COL_RANK, $rank['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(GuestBookItemTableMap::COL_RANK, $rank, $comparison);

        return $this;
    }

    /**
     * Filter the query by a related \Diamond\Infrastructure\Models\GuestBook\GuestBook object
     *
     * @param \Diamond\Infrastructure\Models\GuestBook\GuestBook|ObjectCollection $guestBook The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByGuestBook($guestBook, ?string $comparison = null)
    {
        if ($guestBook instanceof \Diamond\Infrastructure\Models\GuestBook\GuestBook) {
            return $this
                ->addUsingAlias(GuestBookItemTableMap::COL_BOOK_ID, $guestBook->getId(), $comparison);
        } elseif ($guestBook instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(GuestBookItemTableMap::COL_BOOK_ID, $guestBook->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByGuestBook() only accepts arguments of type \Diamond\Infrastructure\Models\GuestBook\GuestBook or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the GuestBook relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinGuestBook(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('GuestBook');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'GuestBook');
        }

        return $this;
    }

    /**
     * Use the GuestBook relation GuestBook object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Infrastructure\Models\GuestBook\GuestBookQuery A secondary query class using the current class as primary query
     */
    public function useGuestBookQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinGuestBook($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'GuestBook', '\Diamond\Infrastructure\Models\GuestBook\GuestBookQuery');
    }

    /**
     * Use the GuestBook relation GuestBook object
     *
     * @param callable(\Diamond\Infrastructure\Models\GuestBook\GuestBookQuery):\Diamond\Infrastructure\Models\GuestBook\GuestBookQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withGuestBookQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useGuestBookQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to GuestBook table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Diamond\Infrastructure\Models\GuestBook\GuestBookQuery The inner query object of the EXISTS statement
     */
    public function useGuestBookExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('GuestBook', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to GuestBook table for a NOT EXISTS query.
     *
     * @see useGuestBookExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Diamond\Infrastructure\Models\GuestBook\GuestBookQuery The inner query object of the NOT EXISTS statement
     */
    public function useGuestBookNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('GuestBook', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Exclude object from result
     *
     * @param ChildGuestBookItem $guestBookItem Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($guestBookItem = null)
    {
        if ($guestBookItem) {
            $this->addUsingAlias(GuestBookItemTableMap::COL_ID, $guestBookItem->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _guest_book_items table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(GuestBookItemTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            GuestBookItemTableMap::clearInstancePool();
            GuestBookItemTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(GuestBookItemTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(GuestBookItemTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            GuestBookItemTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            GuestBookItemTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
