<?php

namespace Diamond\Infrastructure\Models\ContentTagRel\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\Content\Content;
use Diamond\Infrastructure\Models\ContentTag\ContentTag;
use Diamond\Infrastructure\Models\ContentTagRel\ContentTagRel as ChildContentTagRel;
use Diamond\Infrastructure\Models\ContentTagRel\ContentTagRelQuery as ChildContentTagRelQuery;
use Diamond\Infrastructure\Models\ContentTagRel\Map\ContentTagRelTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_content_tag_rel' table.
 *
 *
 *
 * @method     ChildContentTagRelQuery orderByContentTagId($order = Criteria::ASC) Order by the content_tag_id column
 * @method     ChildContentTagRelQuery orderByContentId($order = Criteria::ASC) Order by the content_id column
 *
 * @method     ChildContentTagRelQuery groupByContentTagId() Group by the content_tag_id column
 * @method     ChildContentTagRelQuery groupByContentId() Group by the content_id column
 *
 * @method     ChildContentTagRelQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildContentTagRelQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildContentTagRelQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildContentTagRelQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildContentTagRelQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildContentTagRelQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildContentTagRelQuery leftJoinContentTag($relationAlias = null) Adds a LEFT JOIN clause to the query using the ContentTag relation
 * @method     ChildContentTagRelQuery rightJoinContentTag($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ContentTag relation
 * @method     ChildContentTagRelQuery innerJoinContentTag($relationAlias = null) Adds a INNER JOIN clause to the query using the ContentTag relation
 *
 * @method     ChildContentTagRelQuery joinWithContentTag($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ContentTag relation
 *
 * @method     ChildContentTagRelQuery leftJoinWithContentTag() Adds a LEFT JOIN clause and with to the query using the ContentTag relation
 * @method     ChildContentTagRelQuery rightJoinWithContentTag() Adds a RIGHT JOIN clause and with to the query using the ContentTag relation
 * @method     ChildContentTagRelQuery innerJoinWithContentTag() Adds a INNER JOIN clause and with to the query using the ContentTag relation
 *
 * @method     ChildContentTagRelQuery leftJoinContent($relationAlias = null) Adds a LEFT JOIN clause to the query using the Content relation
 * @method     ChildContentTagRelQuery rightJoinContent($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Content relation
 * @method     ChildContentTagRelQuery innerJoinContent($relationAlias = null) Adds a INNER JOIN clause to the query using the Content relation
 *
 * @method     ChildContentTagRelQuery joinWithContent($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Content relation
 *
 * @method     ChildContentTagRelQuery leftJoinWithContent() Adds a LEFT JOIN clause and with to the query using the Content relation
 * @method     ChildContentTagRelQuery rightJoinWithContent() Adds a RIGHT JOIN clause and with to the query using the Content relation
 * @method     ChildContentTagRelQuery innerJoinWithContent() Adds a INNER JOIN clause and with to the query using the Content relation
 *
 * @method     \Diamond\Infrastructure\Models\ContentTag\ContentTagQuery|\Diamond\Infrastructure\Models\Content\ContentQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildContentTagRel|null findOne(?ConnectionInterface $con = null) Return the first ChildContentTagRel matching the query
 * @method     ChildContentTagRel findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildContentTagRel matching the query, or a new ChildContentTagRel object populated from the query conditions when no match is found
 *
 * @method     ChildContentTagRel|null findOneByContentTagId(int $content_tag_id) Return the first ChildContentTagRel filtered by the content_tag_id column
 * @method     ChildContentTagRel|null findOneByContentId(int $content_id) Return the first ChildContentTagRel filtered by the content_id column *

 * @method     ChildContentTagRel requirePk($key, ?ConnectionInterface $con = null) Return the ChildContentTagRel by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContentTagRel requireOne(?ConnectionInterface $con = null) Return the first ChildContentTagRel matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildContentTagRel requireOneByContentTagId(int $content_tag_id) Return the first ChildContentTagRel filtered by the content_tag_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContentTagRel requireOneByContentId(int $content_id) Return the first ChildContentTagRel filtered by the content_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildContentTagRel[]|Collection find(?ConnectionInterface $con = null) Return ChildContentTagRel objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildContentTagRel> find(?ConnectionInterface $con = null) Return ChildContentTagRel objects based on current ModelCriteria
 * @method     ChildContentTagRel[]|Collection findByContentTagId(int $content_tag_id) Return ChildContentTagRel objects filtered by the content_tag_id column
 * @psalm-method Collection&\Traversable<ChildContentTagRel> findByContentTagId(int $content_tag_id) Return ChildContentTagRel objects filtered by the content_tag_id column
 * @method     ChildContentTagRel[]|Collection findByContentId(int $content_id) Return ChildContentTagRel objects filtered by the content_id column
 * @psalm-method Collection&\Traversable<ChildContentTagRel> findByContentId(int $content_id) Return ChildContentTagRel objects filtered by the content_id column
 * @method     ChildContentTagRel[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildContentTagRel> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ContentTagRelQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Infrastructure\Models\ContentTagRel\Base\ContentTagRelQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Infrastructure\\Models\\ContentTagRel\\ContentTagRel', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildContentTagRelQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildContentTagRelQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildContentTagRelQuery) {
            return $criteria;
        }
        $query = new ChildContentTagRelQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array[$content_tag_id, $content_id] $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildContentTagRel|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ContentTagRelTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ContentTagRelTableMap::getInstanceFromPool(serialize([(null === $key[0] || is_scalar($key[0]) || is_callable([$key[0], '__toString']) ? (string) $key[0] : $key[0]), (null === $key[1] || is_scalar($key[1]) || is_callable([$key[1], '__toString']) ? (string) $key[1] : $key[1])]))))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildContentTagRel A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `content_tag_id`, `content_id` FROM `_content_tag_rel` WHERE `content_tag_id` = :p0 AND `content_id` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildContentTagRel $obj */
            $obj = new ChildContentTagRel();
            $obj->hydrate($row);
            ContentTagRelTableMap::addInstanceToPool($obj, serialize([(null === $key[0] || is_scalar($key[0]) || is_callable([$key[0], '__toString']) ? (string) $key[0] : $key[0]), (null === $key[1] || is_scalar($key[1]) || is_callable([$key[1], '__toString']) ? (string) $key[1] : $key[1])]));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildContentTagRel|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(ContentTagRelTableMap::COL_CONTENT_TAG_ID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(ContentTagRelTableMap::COL_CONTENT_ID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            $this->add(null, '1<>1', Criteria::CUSTOM);

            return $this;
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(ContentTagRelTableMap::COL_CONTENT_TAG_ID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(ContentTagRelTableMap::COL_CONTENT_ID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the content_tag_id column
     *
     * Example usage:
     * <code>
     * $query->filterByContentTagId(1234); // WHERE content_tag_id = 1234
     * $query->filterByContentTagId(array(12, 34)); // WHERE content_tag_id IN (12, 34)
     * $query->filterByContentTagId(array('min' => 12)); // WHERE content_tag_id > 12
     * </code>
     *
     * @see       filterByContentTag()
     *
     * @param mixed $contentTagId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByContentTagId($contentTagId = null, ?string $comparison = null)
    {
        if (is_array($contentTagId)) {
            $useMinMax = false;
            if (isset($contentTagId['min'])) {
                $this->addUsingAlias(ContentTagRelTableMap::COL_CONTENT_TAG_ID, $contentTagId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($contentTagId['max'])) {
                $this->addUsingAlias(ContentTagRelTableMap::COL_CONTENT_TAG_ID, $contentTagId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ContentTagRelTableMap::COL_CONTENT_TAG_ID, $contentTagId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the content_id column
     *
     * Example usage:
     * <code>
     * $query->filterByContentId(1234); // WHERE content_id = 1234
     * $query->filterByContentId(array(12, 34)); // WHERE content_id IN (12, 34)
     * $query->filterByContentId(array('min' => 12)); // WHERE content_id > 12
     * </code>
     *
     * @see       filterByContent()
     *
     * @param mixed $contentId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByContentId($contentId = null, ?string $comparison = null)
    {
        if (is_array($contentId)) {
            $useMinMax = false;
            if (isset($contentId['min'])) {
                $this->addUsingAlias(ContentTagRelTableMap::COL_CONTENT_ID, $contentId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($contentId['max'])) {
                $this->addUsingAlias(ContentTagRelTableMap::COL_CONTENT_ID, $contentId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ContentTagRelTableMap::COL_CONTENT_ID, $contentId, $comparison);

        return $this;
    }

    /**
     * Filter the query by a related \Diamond\Infrastructure\Models\ContentTag\ContentTag object
     *
     * @param \Diamond\Infrastructure\Models\ContentTag\ContentTag|ObjectCollection $contentTag The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByContentTag($contentTag, ?string $comparison = null)
    {
        if ($contentTag instanceof \Diamond\Infrastructure\Models\ContentTag\ContentTag) {
            return $this
                ->addUsingAlias(ContentTagRelTableMap::COL_CONTENT_TAG_ID, $contentTag->getId(), $comparison);
        } elseif ($contentTag instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(ContentTagRelTableMap::COL_CONTENT_TAG_ID, $contentTag->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByContentTag() only accepts arguments of type \Diamond\Infrastructure\Models\ContentTag\ContentTag or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ContentTag relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinContentTag(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ContentTag');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ContentTag');
        }

        return $this;
    }

    /**
     * Use the ContentTag relation ContentTag object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Infrastructure\Models\ContentTag\ContentTagQuery A secondary query class using the current class as primary query
     */
    public function useContentTagQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinContentTag($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ContentTag', '\Diamond\Infrastructure\Models\ContentTag\ContentTagQuery');
    }

    /**
     * Use the ContentTag relation ContentTag object
     *
     * @param callable(\Diamond\Infrastructure\Models\ContentTag\ContentTagQuery):\Diamond\Infrastructure\Models\ContentTag\ContentTagQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withContentTagQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useContentTagQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to ContentTag table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Diamond\Infrastructure\Models\ContentTag\ContentTagQuery The inner query object of the EXISTS statement
     */
    public function useContentTagExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('ContentTag', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to ContentTag table for a NOT EXISTS query.
     *
     * @see useContentTagExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Diamond\Infrastructure\Models\ContentTag\ContentTagQuery The inner query object of the NOT EXISTS statement
     */
    public function useContentTagNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('ContentTag', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Diamond\Infrastructure\Models\Content\Content object
     *
     * @param \Diamond\Infrastructure\Models\Content\Content|ObjectCollection $content The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByContent($content, ?string $comparison = null)
    {
        if ($content instanceof \Diamond\Infrastructure\Models\Content\Content) {
            return $this
                ->addUsingAlias(ContentTagRelTableMap::COL_CONTENT_ID, $content->getId(), $comparison);
        } elseif ($content instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(ContentTagRelTableMap::COL_CONTENT_ID, $content->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByContent() only accepts arguments of type \Diamond\Infrastructure\Models\Content\Content or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Content relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinContent(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Content');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Content');
        }

        return $this;
    }

    /**
     * Use the Content relation Content object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Infrastructure\Models\Content\ContentQuery A secondary query class using the current class as primary query
     */
    public function useContentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinContent($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Content', '\Diamond\Infrastructure\Models\Content\ContentQuery');
    }

    /**
     * Use the Content relation Content object
     *
     * @param callable(\Diamond\Infrastructure\Models\Content\ContentQuery):\Diamond\Infrastructure\Models\Content\ContentQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withContentQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useContentQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Content table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Diamond\Infrastructure\Models\Content\ContentQuery The inner query object of the EXISTS statement
     */
    public function useContentExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Content', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Content table for a NOT EXISTS query.
     *
     * @see useContentExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Diamond\Infrastructure\Models\Content\ContentQuery The inner query object of the NOT EXISTS statement
     */
    public function useContentNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Content', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Exclude object from result
     *
     * @param ChildContentTagRel $contentTagRel Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($contentTagRel = null)
    {
        if ($contentTagRel) {
            $this->addCond('pruneCond0', $this->getAliasedColName(ContentTagRelTableMap::COL_CONTENT_TAG_ID), $contentTagRel->getContentTagId(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(ContentTagRelTableMap::COL_CONTENT_ID), $contentTagRel->getContentId(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _content_tag_rel table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ContentTagRelTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ContentTagRelTableMap::clearInstancePool();
            ContentTagRelTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ContentTagRelTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ContentTagRelTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ContentTagRelTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ContentTagRelTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
