<?php

namespace Diamond\Infrastructure\Models\ContentTag\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\ContentTag\ContentTag as ChildContentTag;
use Diamond\Infrastructure\Models\ContentTag\ContentTagQuery as ChildContentTagQuery;
use Diamond\Infrastructure\Models\ContentTagRel\ContentTagRel;
use Diamond\Infrastructure\Models\ContentTag\Map\ContentTagTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_content_tag' table.
 *
 *
 *
 * @method     ChildContentTagQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildContentTagQuery orderByName($order = Criteria::ASC) Order by the name column
 *
 * @method     ChildContentTagQuery groupById() Group by the id column
 * @method     ChildContentTagQuery groupByName() Group by the name column
 *
 * @method     ChildContentTagQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildContentTagQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildContentTagQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildContentTagQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildContentTagQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildContentTagQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildContentTagQuery leftJoinContentTagRel($relationAlias = null) Adds a LEFT JOIN clause to the query using the ContentTagRel relation
 * @method     ChildContentTagQuery rightJoinContentTagRel($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ContentTagRel relation
 * @method     ChildContentTagQuery innerJoinContentTagRel($relationAlias = null) Adds a INNER JOIN clause to the query using the ContentTagRel relation
 *
 * @method     ChildContentTagQuery joinWithContentTagRel($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ContentTagRel relation
 *
 * @method     ChildContentTagQuery leftJoinWithContentTagRel() Adds a LEFT JOIN clause and with to the query using the ContentTagRel relation
 * @method     ChildContentTagQuery rightJoinWithContentTagRel() Adds a RIGHT JOIN clause and with to the query using the ContentTagRel relation
 * @method     ChildContentTagQuery innerJoinWithContentTagRel() Adds a INNER JOIN clause and with to the query using the ContentTagRel relation
 *
 * @method     \Diamond\Infrastructure\Models\ContentTagRel\ContentTagRelQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildContentTag|null findOne(?ConnectionInterface $con = null) Return the first ChildContentTag matching the query
 * @method     ChildContentTag findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildContentTag matching the query, or a new ChildContentTag object populated from the query conditions when no match is found
 *
 * @method     ChildContentTag|null findOneById(int $id) Return the first ChildContentTag filtered by the id column
 * @method     ChildContentTag|null findOneByName(string $name) Return the first ChildContentTag filtered by the name column *

 * @method     ChildContentTag requirePk($key, ?ConnectionInterface $con = null) Return the ChildContentTag by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContentTag requireOne(?ConnectionInterface $con = null) Return the first ChildContentTag matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildContentTag requireOneById(int $id) Return the first ChildContentTag filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContentTag requireOneByName(string $name) Return the first ChildContentTag filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildContentTag[]|Collection find(?ConnectionInterface $con = null) Return ChildContentTag objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildContentTag> find(?ConnectionInterface $con = null) Return ChildContentTag objects based on current ModelCriteria
 * @method     ChildContentTag[]|Collection findById(int $id) Return ChildContentTag objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildContentTag> findById(int $id) Return ChildContentTag objects filtered by the id column
 * @method     ChildContentTag[]|Collection findByName(string $name) Return ChildContentTag objects filtered by the name column
 * @psalm-method Collection&\Traversable<ChildContentTag> findByName(string $name) Return ChildContentTag objects filtered by the name column
 * @method     ChildContentTag[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildContentTag> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ContentTagQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Infrastructure\Models\ContentTag\Base\ContentTagQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Infrastructure\\Models\\ContentTag\\ContentTag', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildContentTagQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildContentTagQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildContentTagQuery) {
            return $criteria;
        }
        $query = new ChildContentTagQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildContentTag|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ContentTagTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ContentTagTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildContentTag A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name` FROM `_content_tag` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildContentTag $obj */
            $obj = new ChildContentTag();
            $obj->hydrate($row);
            ContentTagTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildContentTag|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(ContentTagTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(ContentTagTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(ContentTagTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(ContentTagTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ContentTagTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * $query->filterByName(['foo', 'bar']); // WHERE name IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $name The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByName($name = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(ContentTagTableMap::COL_NAME, $name, $comparison);

        return $this;
    }

    /**
     * Filter the query by a related \Diamond\Infrastructure\Models\ContentTagRel\ContentTagRel object
     *
     * @param \Diamond\Infrastructure\Models\ContentTagRel\ContentTagRel|ObjectCollection $contentTagRel the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByContentTagRel($contentTagRel, ?string $comparison = null)
    {
        if ($contentTagRel instanceof \Diamond\Infrastructure\Models\ContentTagRel\ContentTagRel) {
            $this
                ->addUsingAlias(ContentTagTableMap::COL_ID, $contentTagRel->getContentTagId(), $comparison);

            return $this;
        } elseif ($contentTagRel instanceof ObjectCollection) {
            $this
                ->useContentTagRelQuery()
                ->filterByPrimaryKeys($contentTagRel->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByContentTagRel() only accepts arguments of type \Diamond\Infrastructure\Models\ContentTagRel\ContentTagRel or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ContentTagRel relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinContentTagRel(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ContentTagRel');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ContentTagRel');
        }

        return $this;
    }

    /**
     * Use the ContentTagRel relation ContentTagRel object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Infrastructure\Models\ContentTagRel\ContentTagRelQuery A secondary query class using the current class as primary query
     */
    public function useContentTagRelQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinContentTagRel($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ContentTagRel', '\Diamond\Infrastructure\Models\ContentTagRel\ContentTagRelQuery');
    }

    /**
     * Use the ContentTagRel relation ContentTagRel object
     *
     * @param callable(\Diamond\Infrastructure\Models\ContentTagRel\ContentTagRelQuery):\Diamond\Infrastructure\Models\ContentTagRel\ContentTagRelQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withContentTagRelQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useContentTagRelQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to ContentTagRel table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Diamond\Infrastructure\Models\ContentTagRel\ContentTagRelQuery The inner query object of the EXISTS statement
     */
    public function useContentTagRelExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('ContentTagRel', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to ContentTagRel table for a NOT EXISTS query.
     *
     * @see useContentTagRelExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Diamond\Infrastructure\Models\ContentTagRel\ContentTagRelQuery The inner query object of the NOT EXISTS statement
     */
    public function useContentTagRelNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('ContentTagRel', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related Content object
     * using the _content_tag_rel table as cross reference
     *
     * @param Content $content the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByContent($content, string $comparison = Criteria::EQUAL)
    {
        $this
            ->useContentTagRelQuery()
            ->filterByContent($content, $comparison)
            ->endUse();

        return $this;
    }

    /**
     * Exclude object from result
     *
     * @param ChildContentTag $contentTag Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($contentTag = null)
    {
        if ($contentTag) {
            $this->addUsingAlias(ContentTagTableMap::COL_ID, $contentTag->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _content_tag table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ContentTagTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ContentTagTableMap::clearInstancePool();
            ContentTagTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ContentTagTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ContentTagTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ContentTagTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ContentTagTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
