<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 26.08.2020
 * Time: 11:12
 */

namespace Diamond\Domain\Menu;


use Core\Repository\DropDownInterface;
use Diamond\Domain\Menu\Contracts\MenuEntityInterface;
use Repo\Concrete\AbstractCollection;

class MenuCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return MenuEntityInterface::class;
    }

    /**
     * @return array
     */
    public function getDropdownList(): array
    {
        $ar = [];
        /**
         * @var MenuEntityInterface $entity
         */
        foreach ($this->_entities as $entity) {
            $ar[$entity->getId()] = $entity->getCountChildrens() > 0 ? '+ '. $entity->getTitle() :
                ($entity->getParentId()>0?'--':'')  . $entity->getTitle();
        }
        return $ar;
    }


}