<?php

namespace Diamond\Domain\Content\Contracts;

use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;

interface ContentCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{

    public function getFilterByDateCreate(): ?string;

    /**
     * @return string|null
     */
    public function getSearchByTitle(): ?string;

    /**
     * @return int|null
     */
    public function getFilterByCategoryId(): ?int;

    /**
     * @return bool|null
     */
    public function getFilterByActive(): ?bool ;


    /**
     * @param string|null $code
     * @return mixed
     */
    public function setFilterByCategoryCode(?string $code);

    /**
     * @return string|null
     */
    public function getFilterByCategoryCode(): ?string;

    /**
     * @param array|null $filterByTagIds
     * @return ContentCriteriaInterface
     */
    public function setFilterByTagIds(?array $filterByTagIds): ContentCriteriaInterface;

    /**
     * @return array|null
     */
    public function getFilterByTagIds(): ?array;

    public function setSortByDateCreate(?string $sortByDateCreate): ContentCriteriaInterface;

    public function getSortByDateCreate(): ?string;
}