<?php

namespace Diamond\Modules\DashboardWidget;

use Core\ModuleController;
use Core\TwigAwareInterface;
use Core\TwigAwareTrait;
use Diamond\Application\Content\ContentService;

/**
 * Description of DashboardWidget
 *
 * @author Diamond Code Generator
 */
class DashboardWidget extends ModuleController implements TwigAwareInterface
{
    use TwigAwareTrait;

    public $position;
    private $contentService;

    /**
     * DashboardWidget constructor.
     * @param ContentService $contentService
     */
    public function __construct(ContentService $contentService)
    {
        $this->contentService = $contentService;
    }


    /**
     * @return string
     * @throws \ReflectionException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function process(): string
    {

        switch ($this->position) {
            case 'center':

                if (!$content = $this
                    ->contentService
                    ->getPromoBlockContentByCode('admin_center')) {
                    return $this->render('center');
                }

                return $this->twig
                    ->createTemplate($content, md5(microtime()))
                    ->render();

            case 'right':

                if (!$content = $this
                    ->contentService
                    ->getPromoBlockContentByCode('admin_right')) {
                    return $this->render('right');
                }

                return $this->twig
                    ->createTemplate($content, md5(microtime()))->render();
                
            case 'search':

                if (!$content = $this
                    ->contentService
                    ->getPromoBlockContentByCode('admin_search')) {
                    return $this->render('search');
                }

                return $this->twig->createTemplate($content, md5(microtime()))->render();

        }

        return '';
    }
}               