<?php

namespace Diamond\Controllers;

use ActiveTableEngine\Concrete\Navigation;
use Core\BaseController;
use Core\Concrete\RequestAwareTrait;
use Core\Contracts\RequestAwareInterface;
use Diamond\Application\System\SystemService;
use Diamond\Repositories\ErrorLog\ErrorLog;
use Symfony\Component\HttpFoundation\Request;

/**
 * Description of Service
 *
 * @author Dmitriy
 */
class ServiceController extends BaseController implements RequestAwareInterface
{
    use RequestAwareTrait;

    protected $templateService;
    protected $errorLogRepo;

   public function __construct(SystemService $templateService, ErrorLog $errorLogRepo)
    {
        $this->errorLogRepo = $errorLogRepo;
        $this->templateService = $templateService;
    }


    /**
     * @param $a
     * @param $b
     * @return int
     */
    public function sortComplex($a, $b): int
    {

        if ($a[0] == $b[0]) {
            return 0;
        }
        return ($a[0] < $b[0]) ? -1 : 1;
    }

    public function compress(): void
    {

        if ($scripts = $this->request->query->get("js")) {
            $type = "js";
        } else {
            $scripts = $this->request->query->get("css");
            $type = "css";
        }

        $this->templateService->compress($scripts, $type);
    }

}