<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 26.08.2020
 * Time: 14:59
 */

namespace Diamond\Repositories\Stat;

use Diamond\Domain\Stat\Contracts\StatCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class StatCriteria extends AbstractCriteria implements StatCriteriaInterface
{

    protected string|null $sortByDateTime = null;

    protected string|null $filterByRequestMethod = null;

    protected string|null $filterByRemoteAddr = null;

    protected string|null $searchByRequestUri = null;

    protected int|null $filterByUserId = null;

    public static function create()
    {
        return new self;
    }

    public function getSortByDateTime(): ?string
    {
        return $this->sortByDateTime;
    }

    /**
     * @param mixed $sortByDateTime
     * @return StatCriteria
     */
    public function setSortByDateTime($sortByDateTime): StatCriteriaInterface
    {
        $this->sortByDateTime = $sortByDateTime;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getFilterByRequestMethod():?string
    {
        return $this->filterByRequestMethod;
    }

    /**
     * @param mixed $filterByRequestMethod
     * @return StatCriteria
     */
    public function setFilterByRequestMethod(?string $filterByRequestMethod): StatCriteriaInterface
    {
        $this->filterByRequestMethod = $filterByRequestMethod;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilterByRemoteAddr(): ?string
    {
        return $this->filterByRemoteAddr;
    }

    /**
     * @param string|null $filterByRemoteAddr
     * @return StatCriteria
     */
    public function setFilterByRemoteAddr(?string $filterByRemoteAddr): StatCriteriaInterface
    {
        $this->filterByRemoteAddr = $filterByRemoteAddr;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByRequestUri(): ?string
    {
        return $this->searchByRequestUri;
    }

    /**
     * @param string|null $searchByRequestUri
     * @return StatCriteria
     */
    public function setSearchByRequestUri(?string $searchByRequestUri): StatCriteriaInterface
    {
        $this->searchByRequestUri = $searchByRequestUri;
        return $this;
    }

    public function getFilterByUserId(): ?int
    {
        return $this->filterByUserId;
    }

    public function setFilterByUserId(?int $filterByUserId): StatCriteriaInterface
    {
        $this->filterByUserId = $filterByUserId;
        return $this;
    }



}