<?

namespace Diamond\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Diamond\Infrastructure\Models\ContentCategory\ContentCategoryQuery;

/**
 * Description of ContentCategory
 *
 * @author Admin
 */
class ContentCategory extends PropelQueryAbstract implements CrudInterface {
    
    public function buildEntity() {
        return new \Diamond\Infrastructure\Models\ContentCategory\ContentCategory();
    }

    public function buildQuery() {
        return ContentCategoryQuery::create();
    }
    
    public function getDropdownList():array {
        return $this->buildQuery()
		->orderByTitle()
		->find()
		->toKeyValue('id','title');
    }

}
