<?php

namespace Diamond\Infrastructure\Models\Page\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\Domain\Domain;
use Diamond\Infrastructure\Models\Page\Page as ChildPage;
use Diamond\Infrastructure\Models\Page\PageQuery as ChildPageQuery;
use Diamond\Infrastructure\Models\Page\PagesArchive as ChildPagesArchive;
use Diamond\Infrastructure\Models\Page\Map\PageTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_pages' table.
 *
 *
 *
 * @method     ChildPageQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildPageQuery orderByCode($order = Criteria::ASC) Order by the code column
 * @method     ChildPageQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildPageQuery orderByUrl($order = Criteria::ASC) Order by the url column
 * @method     ChildPageQuery orderByTemplate($order = Criteria::ASC) Order by the template column
 * @method     ChildPageQuery orderByScript($order = Criteria::ASC) Order by the script column
 * @method     ChildPageQuery orderByContent($order = Criteria::ASC) Order by the content column
 * @method     ChildPageQuery orderBySystem($order = Criteria::ASC) Order by the system column
 * @method     ChildPageQuery orderByActive($order = Criteria::ASC) Order by the active column
 * @method     ChildPageQuery orderByModule($order = Criteria::ASC) Order by the module column
 * @method     ChildPageQuery orderByModuleParams($order = Criteria::ASC) Order by the module_params column
 * @method     ChildPageQuery orderByMtTitle($order = Criteria::ASC) Order by the mt_title column
 * @method     ChildPageQuery orderByMtDescription($order = Criteria::ASC) Order by the mt_description column
 * @method     ChildPageQuery orderByMtKeywords($order = Criteria::ASC) Order by the mt_keywords column
 * @method     ChildPageQuery orderByMtRobots($order = Criteria::ASC) Order by the mt_robots column
 * @method     ChildPageQuery orderBySeoRule($order = Criteria::ASC) Order by the seo_rule column
 * @method     ChildPageQuery orderByPgsSeoFn($order = Criteria::ASC) Order by the pgs_seo_fn column
 * @method     ChildPageQuery orderByDatecreate($order = Criteria::ASC) Order by the datecreate column
 * @method     ChildPageQuery orderByDateUpdate($order = Criteria::ASC) Order by the dateupdate column
 * @method     ChildPageQuery orderByDomainId($order = Criteria::ASC) Order by the domain_id column
 *
 * @method     ChildPageQuery groupById() Group by the id column
 * @method     ChildPageQuery groupByCode() Group by the code column
 * @method     ChildPageQuery groupByTitle() Group by the title column
 * @method     ChildPageQuery groupByUrl() Group by the url column
 * @method     ChildPageQuery groupByTemplate() Group by the template column
 * @method     ChildPageQuery groupByScript() Group by the script column
 * @method     ChildPageQuery groupByContent() Group by the content column
 * @method     ChildPageQuery groupBySystem() Group by the system column
 * @method     ChildPageQuery groupByActive() Group by the active column
 * @method     ChildPageQuery groupByModule() Group by the module column
 * @method     ChildPageQuery groupByModuleParams() Group by the module_params column
 * @method     ChildPageQuery groupByMtTitle() Group by the mt_title column
 * @method     ChildPageQuery groupByMtDescription() Group by the mt_description column
 * @method     ChildPageQuery groupByMtKeywords() Group by the mt_keywords column
 * @method     ChildPageQuery groupByMtRobots() Group by the mt_robots column
 * @method     ChildPageQuery groupBySeoRule() Group by the seo_rule column
 * @method     ChildPageQuery groupByPgsSeoFn() Group by the pgs_seo_fn column
 * @method     ChildPageQuery groupByDatecreate() Group by the datecreate column
 * @method     ChildPageQuery groupByDateUpdate() Group by the dateupdate column
 * @method     ChildPageQuery groupByDomainId() Group by the domain_id column
 *
 * @method     ChildPageQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildPageQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildPageQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildPageQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildPageQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildPageQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildPageQuery leftJoinDomain($relationAlias = null) Adds a LEFT JOIN clause to the query using the Domain relation
 * @method     ChildPageQuery rightJoinDomain($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Domain relation
 * @method     ChildPageQuery innerJoinDomain($relationAlias = null) Adds a INNER JOIN clause to the query using the Domain relation
 *
 * @method     ChildPageQuery joinWithDomain($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Domain relation
 *
 * @method     ChildPageQuery leftJoinWithDomain() Adds a LEFT JOIN clause and with to the query using the Domain relation
 * @method     ChildPageQuery rightJoinWithDomain() Adds a RIGHT JOIN clause and with to the query using the Domain relation
 * @method     ChildPageQuery innerJoinWithDomain() Adds a INNER JOIN clause and with to the query using the Domain relation
 *
 * @method     \Diamond\Infrastructure\Models\Domain\DomainQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildPage|null findOne(?ConnectionInterface $con = null) Return the first ChildPage matching the query
 * @method     ChildPage findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildPage matching the query, or a new ChildPage object populated from the query conditions when no match is found
 *
 * @method     ChildPage|null findOneById(int $id) Return the first ChildPage filtered by the id column
 * @method     ChildPage|null findOneByCode(string $code) Return the first ChildPage filtered by the code column
 * @method     ChildPage|null findOneByTitle(string $title) Return the first ChildPage filtered by the title column
 * @method     ChildPage|null findOneByUrl(string $url) Return the first ChildPage filtered by the url column
 * @method     ChildPage|null findOneByTemplate(string $template) Return the first ChildPage filtered by the template column
 * @method     ChildPage|null findOneByScript(string $script) Return the first ChildPage filtered by the script column
 * @method     ChildPage|null findOneByContent(string $content) Return the first ChildPage filtered by the content column
 * @method     ChildPage|null findOneBySystem(string $system) Return the first ChildPage filtered by the system column
 * @method     ChildPage|null findOneByActive(string $active) Return the first ChildPage filtered by the active column
 * @method     ChildPage|null findOneByModule(string $module) Return the first ChildPage filtered by the module column
 * @method     ChildPage|null findOneByModuleParams(string $module_params) Return the first ChildPage filtered by the module_params column
 * @method     ChildPage|null findOneByMtTitle(string $mt_title) Return the first ChildPage filtered by the mt_title column
 * @method     ChildPage|null findOneByMtDescription(string $mt_description) Return the first ChildPage filtered by the mt_description column
 * @method     ChildPage|null findOneByMtKeywords(string $mt_keywords) Return the first ChildPage filtered by the mt_keywords column
 * @method     ChildPage|null findOneByMtRobots(string $mt_robots) Return the first ChildPage filtered by the mt_robots column
 * @method     ChildPage|null findOneBySeoRule(string $seo_rule) Return the first ChildPage filtered by the seo_rule column
 * @method     ChildPage|null findOneByPgsSeoFn(string $pgs_seo_fn) Return the first ChildPage filtered by the pgs_seo_fn column
 * @method     ChildPage|null findOneByDatecreate(string $datecreate) Return the first ChildPage filtered by the datecreate column
 * @method     ChildPage|null findOneByDateUpdate(string $dateupdate) Return the first ChildPage filtered by the dateupdate column
 * @method     ChildPage|null findOneByDomainId(int $domain_id) Return the first ChildPage filtered by the domain_id column *

 * @method     ChildPage requirePk($key, ?ConnectionInterface $con = null) Return the ChildPage by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOne(?ConnectionInterface $con = null) Return the first ChildPage matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPage requireOneById(int $id) Return the first ChildPage filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByCode(string $code) Return the first ChildPage filtered by the code column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByTitle(string $title) Return the first ChildPage filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByUrl(string $url) Return the first ChildPage filtered by the url column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByTemplate(string $template) Return the first ChildPage filtered by the template column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByScript(string $script) Return the first ChildPage filtered by the script column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByContent(string $content) Return the first ChildPage filtered by the content column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneBySystem(string $system) Return the first ChildPage filtered by the system column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByActive(string $active) Return the first ChildPage filtered by the active column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByModule(string $module) Return the first ChildPage filtered by the module column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByModuleParams(string $module_params) Return the first ChildPage filtered by the module_params column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByMtTitle(string $mt_title) Return the first ChildPage filtered by the mt_title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByMtDescription(string $mt_description) Return the first ChildPage filtered by the mt_description column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByMtKeywords(string $mt_keywords) Return the first ChildPage filtered by the mt_keywords column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByMtRobots(string $mt_robots) Return the first ChildPage filtered by the mt_robots column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneBySeoRule(string $seo_rule) Return the first ChildPage filtered by the seo_rule column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByPgsSeoFn(string $pgs_seo_fn) Return the first ChildPage filtered by the pgs_seo_fn column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByDatecreate(string $datecreate) Return the first ChildPage filtered by the datecreate column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByDateUpdate(string $dateupdate) Return the first ChildPage filtered by the dateupdate column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByDomainId(int $domain_id) Return the first ChildPage filtered by the domain_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPage[]|Collection find(?ConnectionInterface $con = null) Return ChildPage objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildPage> find(?ConnectionInterface $con = null) Return ChildPage objects based on current ModelCriteria
 * @method     ChildPage[]|Collection findById(int $id) Return ChildPage objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildPage> findById(int $id) Return ChildPage objects filtered by the id column
 * @method     ChildPage[]|Collection findByCode(string $code) Return ChildPage objects filtered by the code column
 * @psalm-method Collection&\Traversable<ChildPage> findByCode(string $code) Return ChildPage objects filtered by the code column
 * @method     ChildPage[]|Collection findByTitle(string $title) Return ChildPage objects filtered by the title column
 * @psalm-method Collection&\Traversable<ChildPage> findByTitle(string $title) Return ChildPage objects filtered by the title column
 * @method     ChildPage[]|Collection findByUrl(string $url) Return ChildPage objects filtered by the url column
 * @psalm-method Collection&\Traversable<ChildPage> findByUrl(string $url) Return ChildPage objects filtered by the url column
 * @method     ChildPage[]|Collection findByTemplate(string $template) Return ChildPage objects filtered by the template column
 * @psalm-method Collection&\Traversable<ChildPage> findByTemplate(string $template) Return ChildPage objects filtered by the template column
 * @method     ChildPage[]|Collection findByScript(string $script) Return ChildPage objects filtered by the script column
 * @psalm-method Collection&\Traversable<ChildPage> findByScript(string $script) Return ChildPage objects filtered by the script column
 * @method     ChildPage[]|Collection findByContent(string $content) Return ChildPage objects filtered by the content column
 * @psalm-method Collection&\Traversable<ChildPage> findByContent(string $content) Return ChildPage objects filtered by the content column
 * @method     ChildPage[]|Collection findBySystem(string $system) Return ChildPage objects filtered by the system column
 * @psalm-method Collection&\Traversable<ChildPage> findBySystem(string $system) Return ChildPage objects filtered by the system column
 * @method     ChildPage[]|Collection findByActive(string $active) Return ChildPage objects filtered by the active column
 * @psalm-method Collection&\Traversable<ChildPage> findByActive(string $active) Return ChildPage objects filtered by the active column
 * @method     ChildPage[]|Collection findByModule(string $module) Return ChildPage objects filtered by the module column
 * @psalm-method Collection&\Traversable<ChildPage> findByModule(string $module) Return ChildPage objects filtered by the module column
 * @method     ChildPage[]|Collection findByModuleParams(string $module_params) Return ChildPage objects filtered by the module_params column
 * @psalm-method Collection&\Traversable<ChildPage> findByModuleParams(string $module_params) Return ChildPage objects filtered by the module_params column
 * @method     ChildPage[]|Collection findByMtTitle(string $mt_title) Return ChildPage objects filtered by the mt_title column
 * @psalm-method Collection&\Traversable<ChildPage> findByMtTitle(string $mt_title) Return ChildPage objects filtered by the mt_title column
 * @method     ChildPage[]|Collection findByMtDescription(string $mt_description) Return ChildPage objects filtered by the mt_description column
 * @psalm-method Collection&\Traversable<ChildPage> findByMtDescription(string $mt_description) Return ChildPage objects filtered by the mt_description column
 * @method     ChildPage[]|Collection findByMtKeywords(string $mt_keywords) Return ChildPage objects filtered by the mt_keywords column
 * @psalm-method Collection&\Traversable<ChildPage> findByMtKeywords(string $mt_keywords) Return ChildPage objects filtered by the mt_keywords column
 * @method     ChildPage[]|Collection findByMtRobots(string $mt_robots) Return ChildPage objects filtered by the mt_robots column
 * @psalm-method Collection&\Traversable<ChildPage> findByMtRobots(string $mt_robots) Return ChildPage objects filtered by the mt_robots column
 * @method     ChildPage[]|Collection findBySeoRule(string $seo_rule) Return ChildPage objects filtered by the seo_rule column
 * @psalm-method Collection&\Traversable<ChildPage> findBySeoRule(string $seo_rule) Return ChildPage objects filtered by the seo_rule column
 * @method     ChildPage[]|Collection findByPgsSeoFn(string $pgs_seo_fn) Return ChildPage objects filtered by the pgs_seo_fn column
 * @psalm-method Collection&\Traversable<ChildPage> findByPgsSeoFn(string $pgs_seo_fn) Return ChildPage objects filtered by the pgs_seo_fn column
 * @method     ChildPage[]|Collection findByDatecreate(string $datecreate) Return ChildPage objects filtered by the datecreate column
 * @psalm-method Collection&\Traversable<ChildPage> findByDatecreate(string $datecreate) Return ChildPage objects filtered by the datecreate column
 * @method     ChildPage[]|Collection findByDateUpdate(string $dateupdate) Return ChildPage objects filtered by the dateupdate column
 * @psalm-method Collection&\Traversable<ChildPage> findByDateUpdate(string $dateupdate) Return ChildPage objects filtered by the dateupdate column
 * @method     ChildPage[]|Collection findByDomainId(int $domain_id) Return ChildPage objects filtered by the domain_id column
 * @psalm-method Collection&\Traversable<ChildPage> findByDomainId(int $domain_id) Return ChildPage objects filtered by the domain_id column
 * @method     ChildPage[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildPage> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class PageQuery extends ModelCriteria
{

    // archivable behavior
    protected $archiveOnDelete = true;
protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Infrastructure\Models\Page\Base\PageQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Infrastructure\\Models\\Page\\Page', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildPageQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildPageQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildPageQuery) {
            return $criteria;
        }
        $query = new ChildPageQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildPage|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(PageTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = PageTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildPage A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `code`, `title`, `url`, `template`, `script`, `content`, `system`, `active`, `module`, `module_params`, `mt_title`, `mt_description`, `mt_keywords`, `mt_robots`, `seo_rule`, `pgs_seo_fn`, `datecreate`, `dateupdate`, `domain_id` FROM `_pages` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildPage $obj */
            $obj = new ChildPage();
            $obj->hydrate($row);
            PageTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildPage|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(PageTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(PageTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(PageTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(PageTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the code column
     *
     * Example usage:
     * <code>
     * $query->filterByCode('fooValue');   // WHERE code = 'fooValue'
     * $query->filterByCode('%fooValue%', Criteria::LIKE); // WHERE code LIKE '%fooValue%'
     * $query->filterByCode(['foo', 'bar']); // WHERE code IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $code The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCode($code = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($code)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_CODE, $code, $comparison);

        return $this;
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * $query->filterByTitle(['foo', 'bar']); // WHERE title IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $title The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByTitle($title = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_TITLE, $title, $comparison);

        return $this;
    }

    /**
     * Filter the query on the url column
     *
     * Example usage:
     * <code>
     * $query->filterByUrl('fooValue');   // WHERE url = 'fooValue'
     * $query->filterByUrl('%fooValue%', Criteria::LIKE); // WHERE url LIKE '%fooValue%'
     * $query->filterByUrl(['foo', 'bar']); // WHERE url IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $url The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByUrl($url = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($url)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_URL, $url, $comparison);

        return $this;
    }

    /**
     * Filter the query on the template column
     *
     * Example usage:
     * <code>
     * $query->filterByTemplate('fooValue');   // WHERE template = 'fooValue'
     * $query->filterByTemplate('%fooValue%', Criteria::LIKE); // WHERE template LIKE '%fooValue%'
     * $query->filterByTemplate(['foo', 'bar']); // WHERE template IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $template The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByTemplate($template = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($template)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_TEMPLATE, $template, $comparison);

        return $this;
    }

    /**
     * Filter the query on the script column
     *
     * Example usage:
     * <code>
     * $query->filterByScript('fooValue');   // WHERE script = 'fooValue'
     * $query->filterByScript('%fooValue%', Criteria::LIKE); // WHERE script LIKE '%fooValue%'
     * $query->filterByScript(['foo', 'bar']); // WHERE script IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $script The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByScript($script = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($script)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_SCRIPT, $script, $comparison);

        return $this;
    }

    /**
     * Filter the query on the content column
     *
     * Example usage:
     * <code>
     * $query->filterByContent('fooValue');   // WHERE content = 'fooValue'
     * $query->filterByContent('%fooValue%', Criteria::LIKE); // WHERE content LIKE '%fooValue%'
     * $query->filterByContent(['foo', 'bar']); // WHERE content IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $content The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByContent($content = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($content)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_CONTENT, $content, $comparison);

        return $this;
    }

    /**
     * Filter the query on the system column
     *
     * Example usage:
     * <code>
     * $query->filterBySystem('fooValue');   // WHERE system = 'fooValue'
     * $query->filterBySystem('%fooValue%', Criteria::LIKE); // WHERE system LIKE '%fooValue%'
     * $query->filterBySystem(['foo', 'bar']); // WHERE system IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $system The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterBySystem($system = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($system)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_SYSTEM, $system, $comparison);

        return $this;
    }

    /**
     * Filter the query on the active column
     *
     * Example usage:
     * <code>
     * $query->filterByActive('fooValue');   // WHERE active = 'fooValue'
     * $query->filterByActive('%fooValue%', Criteria::LIKE); // WHERE active LIKE '%fooValue%'
     * $query->filterByActive(['foo', 'bar']); // WHERE active IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $active The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByActive($active = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($active)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_ACTIVE, $active, $comparison);

        return $this;
    }

    /**
     * Filter the query on the module column
     *
     * Example usage:
     * <code>
     * $query->filterByModule('fooValue');   // WHERE module = 'fooValue'
     * $query->filterByModule('%fooValue%', Criteria::LIKE); // WHERE module LIKE '%fooValue%'
     * $query->filterByModule(['foo', 'bar']); // WHERE module IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $module The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByModule($module = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($module)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_MODULE, $module, $comparison);

        return $this;
    }

    /**
     * Filter the query on the module_params column
     *
     * Example usage:
     * <code>
     * $query->filterByModuleParams('fooValue');   // WHERE module_params = 'fooValue'
     * $query->filterByModuleParams('%fooValue%', Criteria::LIKE); // WHERE module_params LIKE '%fooValue%'
     * $query->filterByModuleParams(['foo', 'bar']); // WHERE module_params IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $moduleParams The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByModuleParams($moduleParams = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($moduleParams)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_MODULE_PARAMS, $moduleParams, $comparison);

        return $this;
    }

    /**
     * Filter the query on the mt_title column
     *
     * Example usage:
     * <code>
     * $query->filterByMtTitle('fooValue');   // WHERE mt_title = 'fooValue'
     * $query->filterByMtTitle('%fooValue%', Criteria::LIKE); // WHERE mt_title LIKE '%fooValue%'
     * $query->filterByMtTitle(['foo', 'bar']); // WHERE mt_title IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $mtTitle The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByMtTitle($mtTitle = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtTitle)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_MT_TITLE, $mtTitle, $comparison);

        return $this;
    }

    /**
     * Filter the query on the mt_description column
     *
     * Example usage:
     * <code>
     * $query->filterByMtDescription('fooValue');   // WHERE mt_description = 'fooValue'
     * $query->filterByMtDescription('%fooValue%', Criteria::LIKE); // WHERE mt_description LIKE '%fooValue%'
     * $query->filterByMtDescription(['foo', 'bar']); // WHERE mt_description IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $mtDescription The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByMtDescription($mtDescription = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtDescription)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_MT_DESCRIPTION, $mtDescription, $comparison);

        return $this;
    }

    /**
     * Filter the query on the mt_keywords column
     *
     * Example usage:
     * <code>
     * $query->filterByMtKeywords('fooValue');   // WHERE mt_keywords = 'fooValue'
     * $query->filterByMtKeywords('%fooValue%', Criteria::LIKE); // WHERE mt_keywords LIKE '%fooValue%'
     * $query->filterByMtKeywords(['foo', 'bar']); // WHERE mt_keywords IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $mtKeywords The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByMtKeywords($mtKeywords = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtKeywords)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_MT_KEYWORDS, $mtKeywords, $comparison);

        return $this;
    }

    /**
     * Filter the query on the mt_robots column
     *
     * Example usage:
     * <code>
     * $query->filterByMtRobots('fooValue');   // WHERE mt_robots = 'fooValue'
     * $query->filterByMtRobots('%fooValue%', Criteria::LIKE); // WHERE mt_robots LIKE '%fooValue%'
     * $query->filterByMtRobots(['foo', 'bar']); // WHERE mt_robots IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $mtRobots The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByMtRobots($mtRobots = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtRobots)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_MT_ROBOTS, $mtRobots, $comparison);

        return $this;
    }

    /**
     * Filter the query on the seo_rule column
     *
     * Example usage:
     * <code>
     * $query->filterBySeoRule('fooValue');   // WHERE seo_rule = 'fooValue'
     * $query->filterBySeoRule('%fooValue%', Criteria::LIKE); // WHERE seo_rule LIKE '%fooValue%'
     * $query->filterBySeoRule(['foo', 'bar']); // WHERE seo_rule IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $seoRule The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterBySeoRule($seoRule = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($seoRule)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_SEO_RULE, $seoRule, $comparison);

        return $this;
    }

    /**
     * Filter the query on the pgs_seo_fn column
     *
     * Example usage:
     * <code>
     * $query->filterByPgsSeoFn('fooValue');   // WHERE pgs_seo_fn = 'fooValue'
     * $query->filterByPgsSeoFn('%fooValue%', Criteria::LIKE); // WHERE pgs_seo_fn LIKE '%fooValue%'
     * $query->filterByPgsSeoFn(['foo', 'bar']); // WHERE pgs_seo_fn IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $pgsSeoFn The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPgsSeoFn($pgsSeoFn = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($pgsSeoFn)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_PGS_SEO_FN, $pgsSeoFn, $comparison);

        return $this;
    }

    /**
     * Filter the query on the datecreate column
     *
     * Example usage:
     * <code>
     * $query->filterByDatecreate('2011-03-14'); // WHERE datecreate = '2011-03-14'
     * $query->filterByDatecreate('now'); // WHERE datecreate = '2011-03-14'
     * $query->filterByDatecreate(array('max' => 'yesterday')); // WHERE datecreate > '2011-03-13'
     * </code>
     *
     * @param mixed $datecreate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDatecreate($datecreate = null, ?string $comparison = null)
    {
        if (is_array($datecreate)) {
            $useMinMax = false;
            if (isset($datecreate['min'])) {
                $this->addUsingAlias(PageTableMap::COL_DATECREATE, $datecreate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($datecreate['max'])) {
                $this->addUsingAlias(PageTableMap::COL_DATECREATE, $datecreate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_DATECREATE, $datecreate, $comparison);

        return $this;
    }

    /**
     * Filter the query on the dateupdate column
     *
     * Example usage:
     * <code>
     * $query->filterByDateUpdate('2011-03-14'); // WHERE dateupdate = '2011-03-14'
     * $query->filterByDateUpdate('now'); // WHERE dateupdate = '2011-03-14'
     * $query->filterByDateUpdate(array('max' => 'yesterday')); // WHERE dateupdate > '2011-03-13'
     * </code>
     *
     * @param mixed $dateUpdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDateUpdate($dateUpdate = null, ?string $comparison = null)
    {
        if (is_array($dateUpdate)) {
            $useMinMax = false;
            if (isset($dateUpdate['min'])) {
                $this->addUsingAlias(PageTableMap::COL_DATEUPDATE, $dateUpdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($dateUpdate['max'])) {
                $this->addUsingAlias(PageTableMap::COL_DATEUPDATE, $dateUpdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_DATEUPDATE, $dateUpdate, $comparison);

        return $this;
    }

    /**
     * Filter the query on the domain_id column
     *
     * Example usage:
     * <code>
     * $query->filterByDomainId(1234); // WHERE domain_id = 1234
     * $query->filterByDomainId(array(12, 34)); // WHERE domain_id IN (12, 34)
     * $query->filterByDomainId(array('min' => 12)); // WHERE domain_id > 12
     * </code>
     *
     * @see       filterByDomain()
     *
     * @param mixed $domainId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDomainId($domainId = null, ?string $comparison = null)
    {
        if (is_array($domainId)) {
            $useMinMax = false;
            if (isset($domainId['min'])) {
                $this->addUsingAlias(PageTableMap::COL_DOMAIN_ID, $domainId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($domainId['max'])) {
                $this->addUsingAlias(PageTableMap::COL_DOMAIN_ID, $domainId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(PageTableMap::COL_DOMAIN_ID, $domainId, $comparison);

        return $this;
    }

    /**
     * Filter the query by a related \Diamond\Infrastructure\Models\Domain\Domain object
     *
     * @param \Diamond\Infrastructure\Models\Domain\Domain|ObjectCollection $domain The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByDomain($domain, ?string $comparison = null)
    {
        if ($domain instanceof \Diamond\Infrastructure\Models\Domain\Domain) {
            return $this
                ->addUsingAlias(PageTableMap::COL_DOMAIN_ID, $domain->getId(), $comparison);
        } elseif ($domain instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(PageTableMap::COL_DOMAIN_ID, $domain->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByDomain() only accepts arguments of type \Diamond\Infrastructure\Models\Domain\Domain or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Domain relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinDomain(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Domain');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Domain');
        }

        return $this;
    }

    /**
     * Use the Domain relation Domain object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Infrastructure\Models\Domain\DomainQuery A secondary query class using the current class as primary query
     */
    public function useDomainQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinDomain($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Domain', '\Diamond\Infrastructure\Models\Domain\DomainQuery');
    }

    /**
     * Use the Domain relation Domain object
     *
     * @param callable(\Diamond\Infrastructure\Models\Domain\DomainQuery):\Diamond\Infrastructure\Models\Domain\DomainQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withDomainQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useDomainQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Domain table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Diamond\Infrastructure\Models\Domain\DomainQuery The inner query object of the EXISTS statement
     */
    public function useDomainExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Domain', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Domain table for a NOT EXISTS query.
     *
     * @see useDomainExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Diamond\Infrastructure\Models\Domain\DomainQuery The inner query object of the NOT EXISTS statement
     */
    public function useDomainNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Domain', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Exclude object from result
     *
     * @param ChildPage $page Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($page = null)
    {
        if ($page) {
            $this->addUsingAlias(PageTableMap::COL_ID, $page->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param ConnectionInterface $con The connection object used by the query
     * @return int|null
     */
    protected function basePreDelete(ConnectionInterface $con): ?int
    {
        // archivable behavior

        if ($this->archiveOnDelete) {
            $this->archive($con);
        } else {
            $this->archiveOnDelete = true;
        }


        return $this->preDelete($con);
    }

    /**
     * Deletes all rows from the _pages table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PageTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            PageTableMap::clearInstancePool();
            PageTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PageTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(PageTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            PageTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            PageTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    // archivable behavior

    /**
     * Copy the data of the objects satisfying the query into ChildPagesArchive archive objects.
     * The archived objects are then saved.
     * If any of the objects has already been archived, the archived object
     * is updated and not duplicated.
     * Warning: This termination methods issues 2n+1 queries.
     *
     * @param ConnectionInterface|null $con    Connection to use.
     * @param bool $useLittleMemory Whether to use OnDemandFormatter to retrieve objects.
     *               Set to false if the identity map matters.
     *               Set to true (default) to use less memory.
     *
     * @return int the number of archived objects
     */
    public function archive($con = null, $useLittleMemory = true)
    {
        $criteria = clone $this;
        // prepare the query
        $criteria->setWith(array());
        if ($useLittleMemory) {
            $criteria->setFormatter(ModelCriteria::FORMAT_ON_DEMAND);
        }
        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(PageTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con, $criteria) {
            $totalArchivedObjects = 0;

            // archive all results one by one
            foreach ($criteria->find($con) as $object) {
                $object->archive($con);
                $totalArchivedObjects++;
            }

            return $totalArchivedObjects;
        });
    }

    /**
     * Enable/disable auto-archiving on delete for the next query.
     *
     * @param bool True if the query must archive deleted objects, false otherwise.
     */
    public function setArchiveOnDelete(bool $archiveOnDelete)
    {
        $this->archiveOnDelete = $archiveOnDelete;
    }

    /**
     * Delete records matching the current query without archiving them.
     *
     * @param ConnectionInterface|null $con    Connection to use.
     *
     * @return int The number of deleted rows
     */
    public function deleteWithoutArchive($con = null): int
    {
        $this->archiveOnDelete = false;

        return $this->delete($con);
    }

    /**
     * Delete all records without archiving them.
     *
     * @param ConnectionInterface|null $con    Connection to use.
     *
     * @return int The number of deleted rows
     */
    public function deleteAllWithoutArchive($con = null): int
    {
        $this->archiveOnDelete = false;

        return $this->deleteAll($con);
    }

}
