<?php

namespace Diamond\Infrastructure\Models\MailingMessage\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\MailingMessage\MailingMessage as ChildMailingMessage;
use Diamond\Infrastructure\Models\MailingMessage\MailingMessageQuery as ChildMailingMessageQuery;
use Diamond\Infrastructure\Models\MailingMessage\Map\MailingMessageTableMap;
use Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriber;
use Diamond\Infrastructure\Models\MailingTemplate\MailingTemplate;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_mailing_messages' table.
 *
 *
 *
 * @method     ChildMailingMessageQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildMailingMessageQuery orderByToEmail($order = Criteria::ASC) Order by the to_email column
 * @method     ChildMailingMessageQuery orderByToName($order = Criteria::ASC) Order by the to_name column
 * @method     ChildMailingMessageQuery orderByFromEmail($order = Criteria::ASC) Order by the from_email column
 * @method     ChildMailingMessageQuery orderByFromName($order = Criteria::ASC) Order by the from_name column
 * @method     ChildMailingMessageQuery orderByMatId($order = Criteria::ASC) Order by the mat_id column
 * @method     ChildMailingMessageQuery orderBySubId($order = Criteria::ASC) Order by the sub_id column
 * @method     ChildMailingMessageQuery orderByMalTestMail($order = Criteria::ASC) Order by the mal_test_mail column
 *
 * @method     ChildMailingMessageQuery groupById() Group by the id column
 * @method     ChildMailingMessageQuery groupByToEmail() Group by the to_email column
 * @method     ChildMailingMessageQuery groupByToName() Group by the to_name column
 * @method     ChildMailingMessageQuery groupByFromEmail() Group by the from_email column
 * @method     ChildMailingMessageQuery groupByFromName() Group by the from_name column
 * @method     ChildMailingMessageQuery groupByMatId() Group by the mat_id column
 * @method     ChildMailingMessageQuery groupBySubId() Group by the sub_id column
 * @method     ChildMailingMessageQuery groupByMalTestMail() Group by the mal_test_mail column
 *
 * @method     ChildMailingMessageQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildMailingMessageQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildMailingMessageQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildMailingMessageQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildMailingMessageQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildMailingMessageQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildMailingMessageQuery leftJoinMailingSubscriber($relationAlias = null) Adds a LEFT JOIN clause to the query using the MailingSubscriber relation
 * @method     ChildMailingMessageQuery rightJoinMailingSubscriber($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MailingSubscriber relation
 * @method     ChildMailingMessageQuery innerJoinMailingSubscriber($relationAlias = null) Adds a INNER JOIN clause to the query using the MailingSubscriber relation
 *
 * @method     ChildMailingMessageQuery joinWithMailingSubscriber($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the MailingSubscriber relation
 *
 * @method     ChildMailingMessageQuery leftJoinWithMailingSubscriber() Adds a LEFT JOIN clause and with to the query using the MailingSubscriber relation
 * @method     ChildMailingMessageQuery rightJoinWithMailingSubscriber() Adds a RIGHT JOIN clause and with to the query using the MailingSubscriber relation
 * @method     ChildMailingMessageQuery innerJoinWithMailingSubscriber() Adds a INNER JOIN clause and with to the query using the MailingSubscriber relation
 *
 * @method     ChildMailingMessageQuery leftJoinMailingTemplate($relationAlias = null) Adds a LEFT JOIN clause to the query using the MailingTemplate relation
 * @method     ChildMailingMessageQuery rightJoinMailingTemplate($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MailingTemplate relation
 * @method     ChildMailingMessageQuery innerJoinMailingTemplate($relationAlias = null) Adds a INNER JOIN clause to the query using the MailingTemplate relation
 *
 * @method     ChildMailingMessageQuery joinWithMailingTemplate($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the MailingTemplate relation
 *
 * @method     ChildMailingMessageQuery leftJoinWithMailingTemplate() Adds a LEFT JOIN clause and with to the query using the MailingTemplate relation
 * @method     ChildMailingMessageQuery rightJoinWithMailingTemplate() Adds a RIGHT JOIN clause and with to the query using the MailingTemplate relation
 * @method     ChildMailingMessageQuery innerJoinWithMailingTemplate() Adds a INNER JOIN clause and with to the query using the MailingTemplate relation
 *
 * @method     \Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriberQuery|\Diamond\Infrastructure\Models\MailingTemplate\MailingTemplateQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildMailingMessage|null findOne(?ConnectionInterface $con = null) Return the first ChildMailingMessage matching the query
 * @method     ChildMailingMessage findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildMailingMessage matching the query, or a new ChildMailingMessage object populated from the query conditions when no match is found
 *
 * @method     ChildMailingMessage|null findOneById(int $id) Return the first ChildMailingMessage filtered by the id column
 * @method     ChildMailingMessage|null findOneByToEmail(string $to_email) Return the first ChildMailingMessage filtered by the to_email column
 * @method     ChildMailingMessage|null findOneByToName(string $to_name) Return the first ChildMailingMessage filtered by the to_name column
 * @method     ChildMailingMessage|null findOneByFromEmail(string $from_email) Return the first ChildMailingMessage filtered by the from_email column
 * @method     ChildMailingMessage|null findOneByFromName(string $from_name) Return the first ChildMailingMessage filtered by the from_name column
 * @method     ChildMailingMessage|null findOneByMatId(int $mat_id) Return the first ChildMailingMessage filtered by the mat_id column
 * @method     ChildMailingMessage|null findOneBySubId(int $sub_id) Return the first ChildMailingMessage filtered by the sub_id column
 * @method     ChildMailingMessage|null findOneByMalTestMail(string $mal_test_mail) Return the first ChildMailingMessage filtered by the mal_test_mail column *

 * @method     ChildMailingMessage requirePk($key, ?ConnectionInterface $con = null) Return the ChildMailingMessage by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingMessage requireOne(?ConnectionInterface $con = null) Return the first ChildMailingMessage matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildMailingMessage requireOneById(int $id) Return the first ChildMailingMessage filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingMessage requireOneByToEmail(string $to_email) Return the first ChildMailingMessage filtered by the to_email column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingMessage requireOneByToName(string $to_name) Return the first ChildMailingMessage filtered by the to_name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingMessage requireOneByFromEmail(string $from_email) Return the first ChildMailingMessage filtered by the from_email column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingMessage requireOneByFromName(string $from_name) Return the first ChildMailingMessage filtered by the from_name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingMessage requireOneByMatId(int $mat_id) Return the first ChildMailingMessage filtered by the mat_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingMessage requireOneBySubId(int $sub_id) Return the first ChildMailingMessage filtered by the sub_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingMessage requireOneByMalTestMail(string $mal_test_mail) Return the first ChildMailingMessage filtered by the mal_test_mail column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildMailingMessage[]|Collection find(?ConnectionInterface $con = null) Return ChildMailingMessage objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildMailingMessage> find(?ConnectionInterface $con = null) Return ChildMailingMessage objects based on current ModelCriteria
 * @method     ChildMailingMessage[]|Collection findById(int $id) Return ChildMailingMessage objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildMailingMessage> findById(int $id) Return ChildMailingMessage objects filtered by the id column
 * @method     ChildMailingMessage[]|Collection findByToEmail(string $to_email) Return ChildMailingMessage objects filtered by the to_email column
 * @psalm-method Collection&\Traversable<ChildMailingMessage> findByToEmail(string $to_email) Return ChildMailingMessage objects filtered by the to_email column
 * @method     ChildMailingMessage[]|Collection findByToName(string $to_name) Return ChildMailingMessage objects filtered by the to_name column
 * @psalm-method Collection&\Traversable<ChildMailingMessage> findByToName(string $to_name) Return ChildMailingMessage objects filtered by the to_name column
 * @method     ChildMailingMessage[]|Collection findByFromEmail(string $from_email) Return ChildMailingMessage objects filtered by the from_email column
 * @psalm-method Collection&\Traversable<ChildMailingMessage> findByFromEmail(string $from_email) Return ChildMailingMessage objects filtered by the from_email column
 * @method     ChildMailingMessage[]|Collection findByFromName(string $from_name) Return ChildMailingMessage objects filtered by the from_name column
 * @psalm-method Collection&\Traversable<ChildMailingMessage> findByFromName(string $from_name) Return ChildMailingMessage objects filtered by the from_name column
 * @method     ChildMailingMessage[]|Collection findByMatId(int $mat_id) Return ChildMailingMessage objects filtered by the mat_id column
 * @psalm-method Collection&\Traversable<ChildMailingMessage> findByMatId(int $mat_id) Return ChildMailingMessage objects filtered by the mat_id column
 * @method     ChildMailingMessage[]|Collection findBySubId(int $sub_id) Return ChildMailingMessage objects filtered by the sub_id column
 * @psalm-method Collection&\Traversable<ChildMailingMessage> findBySubId(int $sub_id) Return ChildMailingMessage objects filtered by the sub_id column
 * @method     ChildMailingMessage[]|Collection findByMalTestMail(string $mal_test_mail) Return ChildMailingMessage objects filtered by the mal_test_mail column
 * @psalm-method Collection&\Traversable<ChildMailingMessage> findByMalTestMail(string $mal_test_mail) Return ChildMailingMessage objects filtered by the mal_test_mail column
 * @method     ChildMailingMessage[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildMailingMessage> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class MailingMessageQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Infrastructure\Models\MailingMessage\Base\MailingMessageQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Infrastructure\\Models\\MailingMessage\\MailingMessage', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildMailingMessageQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildMailingMessageQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildMailingMessageQuery) {
            return $criteria;
        }
        $query = new ChildMailingMessageQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildMailingMessage|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(MailingMessageTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = MailingMessageTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildMailingMessage A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `to_email`, `to_name`, `from_email`, `from_name`, `mat_id`, `sub_id`, `mal_test_mail` FROM `_mailing_messages` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildMailingMessage $obj */
            $obj = new ChildMailingMessage();
            $obj->hydrate($row);
            MailingMessageTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildMailingMessage|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(MailingMessageTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(MailingMessageTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(MailingMessageTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(MailingMessageTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingMessageTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the to_email column
     *
     * Example usage:
     * <code>
     * $query->filterByToEmail('fooValue');   // WHERE to_email = 'fooValue'
     * $query->filterByToEmail('%fooValue%', Criteria::LIKE); // WHERE to_email LIKE '%fooValue%'
     * $query->filterByToEmail(['foo', 'bar']); // WHERE to_email IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $toEmail The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByToEmail($toEmail = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($toEmail)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingMessageTableMap::COL_TO_EMAIL, $toEmail, $comparison);

        return $this;
    }

    /**
     * Filter the query on the to_name column
     *
     * Example usage:
     * <code>
     * $query->filterByToName('fooValue');   // WHERE to_name = 'fooValue'
     * $query->filterByToName('%fooValue%', Criteria::LIKE); // WHERE to_name LIKE '%fooValue%'
     * $query->filterByToName(['foo', 'bar']); // WHERE to_name IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $toName The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByToName($toName = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($toName)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingMessageTableMap::COL_TO_NAME, $toName, $comparison);

        return $this;
    }

    /**
     * Filter the query on the from_email column
     *
     * Example usage:
     * <code>
     * $query->filterByFromEmail('fooValue');   // WHERE from_email = 'fooValue'
     * $query->filterByFromEmail('%fooValue%', Criteria::LIKE); // WHERE from_email LIKE '%fooValue%'
     * $query->filterByFromEmail(['foo', 'bar']); // WHERE from_email IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $fromEmail The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByFromEmail($fromEmail = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($fromEmail)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingMessageTableMap::COL_FROM_EMAIL, $fromEmail, $comparison);

        return $this;
    }

    /**
     * Filter the query on the from_name column
     *
     * Example usage:
     * <code>
     * $query->filterByFromName('fooValue');   // WHERE from_name = 'fooValue'
     * $query->filterByFromName('%fooValue%', Criteria::LIKE); // WHERE from_name LIKE '%fooValue%'
     * $query->filterByFromName(['foo', 'bar']); // WHERE from_name IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $fromName The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByFromName($fromName = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($fromName)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingMessageTableMap::COL_FROM_NAME, $fromName, $comparison);

        return $this;
    }

    /**
     * Filter the query on the mat_id column
     *
     * Example usage:
     * <code>
     * $query->filterByMatId(1234); // WHERE mat_id = 1234
     * $query->filterByMatId(array(12, 34)); // WHERE mat_id IN (12, 34)
     * $query->filterByMatId(array('min' => 12)); // WHERE mat_id > 12
     * </code>
     *
     * @see       filterByMailingTemplate()
     *
     * @param mixed $matId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByMatId($matId = null, ?string $comparison = null)
    {
        if (is_array($matId)) {
            $useMinMax = false;
            if (isset($matId['min'])) {
                $this->addUsingAlias(MailingMessageTableMap::COL_MAT_ID, $matId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($matId['max'])) {
                $this->addUsingAlias(MailingMessageTableMap::COL_MAT_ID, $matId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingMessageTableMap::COL_MAT_ID, $matId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the sub_id column
     *
     * Example usage:
     * <code>
     * $query->filterBySubId(1234); // WHERE sub_id = 1234
     * $query->filterBySubId(array(12, 34)); // WHERE sub_id IN (12, 34)
     * $query->filterBySubId(array('min' => 12)); // WHERE sub_id > 12
     * </code>
     *
     * @see       filterByMailingSubscriber()
     *
     * @param mixed $subId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterBySubId($subId = null, ?string $comparison = null)
    {
        if (is_array($subId)) {
            $useMinMax = false;
            if (isset($subId['min'])) {
                $this->addUsingAlias(MailingMessageTableMap::COL_SUB_ID, $subId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($subId['max'])) {
                $this->addUsingAlias(MailingMessageTableMap::COL_SUB_ID, $subId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingMessageTableMap::COL_SUB_ID, $subId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the mal_test_mail column
     *
     * Example usage:
     * <code>
     * $query->filterByMalTestMail('fooValue');   // WHERE mal_test_mail = 'fooValue'
     * $query->filterByMalTestMail('%fooValue%', Criteria::LIKE); // WHERE mal_test_mail LIKE '%fooValue%'
     * $query->filterByMalTestMail(['foo', 'bar']); // WHERE mal_test_mail IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $malTestMail The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByMalTestMail($malTestMail = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($malTestMail)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MailingMessageTableMap::COL_MAL_TEST_MAIL, $malTestMail, $comparison);

        return $this;
    }

    /**
     * Filter the query by a related \Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriber object
     *
     * @param \Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriber|ObjectCollection $mailingSubscriber The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByMailingSubscriber($mailingSubscriber, ?string $comparison = null)
    {
        if ($mailingSubscriber instanceof \Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriber) {
            return $this
                ->addUsingAlias(MailingMessageTableMap::COL_SUB_ID, $mailingSubscriber->getId(), $comparison);
        } elseif ($mailingSubscriber instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(MailingMessageTableMap::COL_SUB_ID, $mailingSubscriber->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByMailingSubscriber() only accepts arguments of type \Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriber or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MailingSubscriber relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinMailingSubscriber(?string $relationAlias = null, ?string $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MailingSubscriber');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MailingSubscriber');
        }

        return $this;
    }

    /**
     * Use the MailingSubscriber relation MailingSubscriber object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriberQuery A secondary query class using the current class as primary query
     */
    public function useMailingSubscriberQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMailingSubscriber($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MailingSubscriber', '\Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriberQuery');
    }

    /**
     * Use the MailingSubscriber relation MailingSubscriber object
     *
     * @param callable(\Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriberQuery):\Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriberQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withMailingSubscriberQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::LEFT_JOIN
    ) {
        $relatedQuery = $this->useMailingSubscriberQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to MailingSubscriber table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriberQuery The inner query object of the EXISTS statement
     */
    public function useMailingSubscriberExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('MailingSubscriber', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to MailingSubscriber table for a NOT EXISTS query.
     *
     * @see useMailingSubscriberExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriberQuery The inner query object of the NOT EXISTS statement
     */
    public function useMailingSubscriberNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('MailingSubscriber', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \Diamond\Infrastructure\Models\MailingTemplate\MailingTemplate object
     *
     * @param \Diamond\Infrastructure\Models\MailingTemplate\MailingTemplate|ObjectCollection $mailingTemplate The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByMailingTemplate($mailingTemplate, ?string $comparison = null)
    {
        if ($mailingTemplate instanceof \Diamond\Infrastructure\Models\MailingTemplate\MailingTemplate) {
            return $this
                ->addUsingAlias(MailingMessageTableMap::COL_MAT_ID, $mailingTemplate->getId(), $comparison);
        } elseif ($mailingTemplate instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(MailingMessageTableMap::COL_MAT_ID, $mailingTemplate->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByMailingTemplate() only accepts arguments of type \Diamond\Infrastructure\Models\MailingTemplate\MailingTemplate or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MailingTemplate relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinMailingTemplate(?string $relationAlias = null, ?string $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MailingTemplate');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MailingTemplate');
        }

        return $this;
    }

    /**
     * Use the MailingTemplate relation MailingTemplate object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Infrastructure\Models\MailingTemplate\MailingTemplateQuery A secondary query class using the current class as primary query
     */
    public function useMailingTemplateQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMailingTemplate($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MailingTemplate', '\Diamond\Infrastructure\Models\MailingTemplate\MailingTemplateQuery');
    }

    /**
     * Use the MailingTemplate relation MailingTemplate object
     *
     * @param callable(\Diamond\Infrastructure\Models\MailingTemplate\MailingTemplateQuery):\Diamond\Infrastructure\Models\MailingTemplate\MailingTemplateQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withMailingTemplateQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::LEFT_JOIN
    ) {
        $relatedQuery = $this->useMailingTemplateQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to MailingTemplate table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Diamond\Infrastructure\Models\MailingTemplate\MailingTemplateQuery The inner query object of the EXISTS statement
     */
    public function useMailingTemplateExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('MailingTemplate', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to MailingTemplate table for a NOT EXISTS query.
     *
     * @see useMailingTemplateExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Diamond\Infrastructure\Models\MailingTemplate\MailingTemplateQuery The inner query object of the NOT EXISTS statement
     */
    public function useMailingTemplateNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('MailingTemplate', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Exclude object from result
     *
     * @param ChildMailingMessage $mailingMessage Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($mailingMessage = null)
    {
        if ($mailingMessage) {
            $this->addUsingAlias(MailingMessageTableMap::COL_ID, $mailingMessage->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _mailing_messages table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MailingMessageTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            MailingMessageTableMap::clearInstancePool();
            MailingMessageTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MailingMessageTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(MailingMessageTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            MailingMessageTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            MailingMessageTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
