<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 20.08.2020
 * Time: 20:33
 */

namespace Diamond\Domain\Stat\Contracts;

use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;

interface StatCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{

    public function getSortById():?string;

    public function getSortByDateTime():?string;

    public function getFilterById():?int;

    public function getFilterByRequestMethod():?string ;

    public function getFilterByRemoteAddr():?string ;

    public function getSearchByRequestUri():?string ;

    public function setFilterByUserId(?int $filterByUserId): StatCriteriaInterface;

    public function setSearchByRequestUri(?string $searchByRequestUri): StatCriteriaInterface;

    public function setFilterByRemoteAddr(?string $filterByRemoteAddr): StatCriteriaInterface;

    public function setFilterByRequestMethod(?string $filterByRequestMethod): StatCriteriaInterface;

    public function setSortByDateTime($sortByDateTime): StatCriteriaInterface;

    public function getFilterByUserId(): ?int;
}