<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 10.09.2020
 * Time: 21:34
 */

namespace Diamond\Domain\MailingSubscriber;


use Core\Repository\DropDownInterface;
use Diamond\Domain\MailingSubscriber\Contracts\MailingSubscriberEntityInterface;
use Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriber;
use Repo\CollectionInterface;
use Repo\Concrete\AbstractCollection;

class MailingSubscriberCollection extends AbstractCollection implements DropDownInterface
{
    protected function getEntityClass(): string
    {
        return MailingSubscriberEntityInterface::class;
    }

    /**
     * @return array
     */
    public function getDropdownList(): array
    {
        $ar = [];
        /**
         * @var MailingSubscriber $entity
         */
        foreach ($this->_entities as $entity){
            $ar[$entity->getId()] = $entity->getTitle();
        }
        return $ar;
    }

}