<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 26.08.2020
 * Time: 11:12
 */

namespace Diamond\Domain\ContentCategory;


use Core\Repository\DropDownInterface;
use Diamond\Domain\ContentCategory\Contracts\ContentCategoryEntityInterface;
use Repo\Concrete\AbstractCollection;
use Repo\Concrete\AbstractEntity;

class ContentCategoryCollection extends AbstractCollection implements DropDownInterface
{
    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return ContentCategoryEntityInterface::class;
    }

    /**
     * @return array
     */
    public function getDropdownList(): array
    {
        $ar = [];
        foreach($this->_entities as $entity){
            $ar[$entity->getId()] = $entity->getTitle();
        }

        return $ar;
    }
}