<?php

namespace Diamond\Modules\AdminArchiveContents;

use ActiveTable\ColumnTable;
use ActiveTable\DataTableEngine;
use Core\Form\ControlBuilder;
use Diamond\Domain\Content\Contracts\ContentEntityInterface;
use Diamond\Modules\AdminContents\AdminContents;
use Diamond\Repositories\Content\ArchiveContentRepository;
use Diamond\Repositories\Content\ContentCriteria;
use Diamond\Repositories\ContentCategory\ContentCategoryCriteria;
use Diamond\Repositories\ContentCategory\ContentCategoryRepository;
use DiamondTable\CommandFactory;
use DiamondTable\TableFactory;

/**
 * Description of AdminArchiveContents
 *
 * @author Diamond Code Generator
 */
class AdminArchiveContents extends AdminContents
{

    protected $tableFactory;
    protected $archiveContentRepository;
    protected $controlBuilder;
    protected $categoryRepository;

    public function __construct(
                    TableFactory $tableFactory,
                    ArchiveContentRepository $archiveContentRepository,
                    ControlBuilder $controlBuilder,
                    ContentCategoryRepository $categoryRepository
    )
    {
        $this->archiveContentRepository = $archiveContentRepository;
        $this->tableFactory = $tableFactory;
        $this->builder = $controlBuilder;
        $this->categoryRepository = $categoryRepository;
    }

    /**
     * @return string
     * @throws \ReflectionException
     * @throws \Repo\Concrete\Exceptions\Collection
     */
    public function process(): string
    {
        $categories = $this->categoryRepository->findByCriteria(ContentCategoryCriteria::create());
        $table = $this->tableFactory->buildAdminTable($this->archiveContentRepository, ContentCriteria::create());
        $table->removeControlAccess(DataTableEngine::CONTROL_ACCESS_ADD);
        $table
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('datecreate', 'Дата создания'))
                    ->setFormat($this, 'formatDate')
            )
            ->addColumn(
                (new ColumnTable('title', 'Заголовок'))
            )
            ->addColumn(
                (new ColumnTable('preview', 'Краткий текст'))
                    ->setFormat($this, 'formatPreview')
            )
            ->addColumn(
                (new ColumnTable('body', 'Полный текст'))
                    ->setFormat($this, 'formatBody')
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this, 'formatActions')
                    ->setWidth(120)
            )
            ->addRowActionCommand('restore-selected', new RestoreCommand($table),'Восстановить')
        ;

        $this->makeFilter($table, $categories);

        return $table->render();
    }


    /**
     * @param ContentEntityInterface $contentEntity
     * @return string
     */
    public function formatActions(ContentEntityInterface $contentEntity): string
    {
        $items = [];


        $items [] = anchor('javascript:void(0);', 'Восстановить', [
            'onclick' => "action_row({$contentEntity->getId()},'restore-selected','Восстановить материал?')"
        ]);

        $items [] = anchor('javascript:void(0);', 'Удалить', [
            'onclick' => "action_row({$contentEntity->getId()},'".CommandFactory::ROWS_DELETE."','Действительно удалить материал?')"
        ]);

        return $this->builder->buildActionMenu($items)->render();
    }
}               