<?php


namespace Diamond\Factory;

use Diamond\Infrastructure\Models\Page\Page;

/**
 * Class AbstractPageFactory
 * @package Diamond\Factory
 */
abstract class AbstractPageFactory
{
    /**
     * @return Page
     */
    abstract public function createPage404(): Page;

    /**
     * @return Page
     */
    abstract public function createPage403(): Page;

    /**
     * @param Page $page
     * @return string
     */
    abstract public function renderPage(Page $page): string;
}