<?php

namespace Diamond\Infrastructure\Models\StatRule\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\StatRule\StatRuleQuery as ChildStatRuleQuery;
use Diamond\Infrastructure\Models\StatRule\Map\StatRuleTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;

/**
 * Base class that represents a row from the '_stat_rules' table.
 *
 *
 *
 * @package    propel.generator.Diamond.Infrastructure.Models.StatRule.Base
 */
abstract class StatRule implements ActiveRecordInterface
{
    /**
     * TableMap class name
     *
     * @var string
     */
    public const TABLE_MAP = '\\Diamond\\Infrastructure\\Models\\StatRule\\Map\\StatRuleTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var bool
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var bool
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = [];

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = [];

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     *
     * @var        string
     */
    protected $name;

    /**
     * The value for the client_type field.
     *
     * Note: this column has a database default value of: '%'
     * @var        string
     */
    protected $client_type;

    /**
     * The value for the uri_mask field.
     *
     * Note: this column has a database default value of: '%'
     * @var        string
     */
    protected $uri_mask;

    /**
     * The value for the ip_mask field.
     *
     * Note: this column has a database default value of: '%'
     * @var        string
     */
    protected $ip_mask;

    /**
     * The value for the agent_mask field.
     *
     * Note: this column has a database default value of: '%'
     * @var        string
     */
    protected $agent_mask;

    /**
     * The value for the host_mask field.
     *
     * Note: this column has a database default value of: '%'
     * @var        string
     */
    protected $host_mask;

    /**
     * The value for the rule field.
     *
     * Note: this column has a database default value of: 'DENY'
     * @var        string
     */
    protected $rule;

    /**
     * The value for the period field.
     *
     * @var        int|null
     */
    protected $period;

    /**
     * The value for the ban_rate field.
     *
     * @var        int|null
     */
    protected $ban_rate;

    /**
     * The value for the ban_uri field.
     *
     * @var        string|null
     */
    protected $ban_uri;

    /**
     * The value for the ban_period field.
     *
     * @var        int|null
     */
    protected $ban_period;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var bool
     */
    protected $alreadyInSave = false;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues(): void
    {
        $this->client_type = '%';
        $this->uri_mask = '%';
        $this->ip_mask = '%';
        $this->agent_mask = '%';
        $this->host_mask = '%';
        $this->rule = 'DENY';
    }

    /**
     * Initializes internal state of Diamond\Infrastructure\Models\StatRule\Base\StatRule object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return bool True if the object has been modified.
     */
    public function isModified(): bool
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param string $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return bool True if $col has been modified.
     */
    public function isColumnModified(string $col): bool
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns(): array
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return bool True, if the object has never been persisted.
     */
    public function isNew(): bool
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param bool $b the state of the object.
     */
    public function setNew(bool $b): void
    {
        $this->new = $b;
    }

    /**
     * Whether this object has been deleted.
     * @return bool The deleted state of this object.
     */
    public function isDeleted(): bool
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param bool $b The deleted state of this object.
     * @return void
     */
    public function setDeleted(bool $b): void
    {
        $this->deleted = $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified(?string $col = null): void
    {
        if (null !== $col) {
            unset($this->modifiedColumns[$col]);
        } else {
            $this->modifiedColumns = [];
        }
    }

    /**
     * Compares this with another <code>StatRule</code> instance.  If
     * <code>obj</code> is an instance of <code>StatRule</code>, delegates to
     * <code>equals(StatRule)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param mixed $obj The object to compare to.
     * @return bool Whether equal to the object specified.
     */
    public function equals($obj): bool
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns(): array
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return bool
     */
    public function hasVirtualColumn(string $name): bool
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return mixed
     *
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getVirtualColumn(string $name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of nonexistent virtual column `%s`.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @param mixed $value The value to give to the virtual column
     *
     * @return $this The current object, for fluid interface
     */
    public function setVirtualColumn(string $name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param string $msg
     * @param int $priority One of the Propel::LOG_* logging levels
     * @return void
     */
    protected function log(string $msg, int $priority = Propel::LOG_INFO): void
    {
        Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param \Propel\Runtime\Parser\AbstractParser|string $parser An AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME, TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM. Defaults to TableMap::TYPE_PHPNAME.
     * @return string The exported data
     */
    public function exportTo($parser, bool $includeLazyLoadColumns = true, string $keyType = TableMap::TYPE_PHPNAME): string
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray($keyType, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     *
     * @return array<string>
     */
    public function __sleep(): array
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [client_type] column value.
     *
     * @return string
     */
    public function getClientType()
    {
        return $this->client_type;
    }

    /**
     * Get the [uri_mask] column value.
     *
     * @return string
     */
    public function getUriMask()
    {
        return $this->uri_mask;
    }

    /**
     * Get the [ip_mask] column value.
     *
     * @return string
     */
    public function getIpMask()
    {
        return $this->ip_mask;
    }

    /**
     * Get the [agent_mask] column value.
     *
     * @return string
     */
    public function getAgentMask()
    {
        return $this->agent_mask;
    }

    /**
     * Get the [host_mask] column value.
     *
     * @return string
     */
    public function getHostMask()
    {
        return $this->host_mask;
    }

    /**
     * Get the [rule] column value.
     *
     * @return string
     */
    public function getRule()
    {
        return $this->rule;
    }

    /**
     * Get the [period] column value.
     *
     * @return int|null
     */
    public function getPeriod()
    {
        return $this->period;
    }

    /**
     * Get the [ban_rate] column value.
     *
     * @return int|null
     */
    public function getBanRate()
    {
        return $this->ban_rate;
    }

    /**
     * Get the [ban_uri] column value.
     *
     * @return string|null
     */
    public function getBanUri()
    {
        return $this->ban_uri;
    }

    /**
     * Get the [ban_period] column value.
     *
     * @return int|null
     */
    public function getBanPeriod()
    {
        return $this->ban_period;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[StatRuleTableMap::COL_ID] = true;
        }

        return $this;
    }

    /**
     * Set the value of [name] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[StatRuleTableMap::COL_NAME] = true;
        }

        return $this;
    }

    /**
     * Set the value of [client_type] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setClientType($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->client_type !== $v) {
            $this->client_type = $v;
            $this->modifiedColumns[StatRuleTableMap::COL_CLIENT_TYPE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [uri_mask] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setUriMask($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->uri_mask !== $v) {
            $this->uri_mask = $v;
            $this->modifiedColumns[StatRuleTableMap::COL_URI_MASK] = true;
        }

        return $this;
    }

    /**
     * Set the value of [ip_mask] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setIpMask($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->ip_mask !== $v) {
            $this->ip_mask = $v;
            $this->modifiedColumns[StatRuleTableMap::COL_IP_MASK] = true;
        }

        return $this;
    }

    /**
     * Set the value of [agent_mask] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setAgentMask($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->agent_mask !== $v) {
            $this->agent_mask = $v;
            $this->modifiedColumns[StatRuleTableMap::COL_AGENT_MASK] = true;
        }

        return $this;
    }

    /**
     * Set the value of [host_mask] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setHostMask($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->host_mask !== $v) {
            $this->host_mask = $v;
            $this->modifiedColumns[StatRuleTableMap::COL_HOST_MASK] = true;
        }

        return $this;
    }

    /**
     * Set the value of [rule] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setRule($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->rule !== $v) {
            $this->rule = $v;
            $this->modifiedColumns[StatRuleTableMap::COL_RULE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [period] column.
     *
     * @param int|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setPeriod($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->period !== $v) {
            $this->period = $v;
            $this->modifiedColumns[StatRuleTableMap::COL_PERIOD] = true;
        }

        return $this;
    }

    /**
     * Set the value of [ban_rate] column.
     *
     * @param int|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setBanRate($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->ban_rate !== $v) {
            $this->ban_rate = $v;
            $this->modifiedColumns[StatRuleTableMap::COL_BAN_RATE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [ban_uri] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setBanUri($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->ban_uri !== $v) {
            $this->ban_uri = $v;
            $this->modifiedColumns[StatRuleTableMap::COL_BAN_URI] = true;
        }

        return $this;
    }

    /**
     * Set the value of [ban_period] column.
     *
     * @param int|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setBanPeriod($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->ban_period !== $v) {
            $this->ban_period = $v;
            $this->modifiedColumns[StatRuleTableMap::COL_BAN_PERIOD] = true;
        }

        return $this;
    }

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return bool Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues(): bool
    {
            if ($this->client_type !== '%') {
                return false;
            }

            if ($this->uri_mask !== '%') {
                return false;
            }

            if ($this->ip_mask !== '%') {
                return false;
            }

            if ($this->agent_mask !== '%') {
                return false;
            }

            if ($this->host_mask !== '%') {
                return false;
            }

            if ($this->rule !== 'DENY') {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    }

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by DataFetcher->fetch().
     * @param int $startcol 0-based offset column which indicates which resultset column to start with.
     * @param bool $rehydrate Whether this object is being re-hydrated from the database.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int next starting column
     * @throws \Propel\Runtime\Exception\PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate(array $row, int $startcol = 0, bool $rehydrate = false, string $indexType = TableMap::TYPE_NUM): int
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : StatRuleTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : StatRuleTableMap::translateFieldName('Name', TableMap::TYPE_PHPNAME, $indexType)];
            $this->name = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : StatRuleTableMap::translateFieldName('ClientType', TableMap::TYPE_PHPNAME, $indexType)];
            $this->client_type = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : StatRuleTableMap::translateFieldName('UriMask', TableMap::TYPE_PHPNAME, $indexType)];
            $this->uri_mask = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : StatRuleTableMap::translateFieldName('IpMask', TableMap::TYPE_PHPNAME, $indexType)];
            $this->ip_mask = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : StatRuleTableMap::translateFieldName('AgentMask', TableMap::TYPE_PHPNAME, $indexType)];
            $this->agent_mask = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : StatRuleTableMap::translateFieldName('HostMask', TableMap::TYPE_PHPNAME, $indexType)];
            $this->host_mask = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : StatRuleTableMap::translateFieldName('Rule', TableMap::TYPE_PHPNAME, $indexType)];
            $this->rule = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 8 + $startcol : StatRuleTableMap::translateFieldName('Period', TableMap::TYPE_PHPNAME, $indexType)];
            $this->period = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 9 + $startcol : StatRuleTableMap::translateFieldName('BanRate', TableMap::TYPE_PHPNAME, $indexType)];
            $this->ban_rate = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 10 + $startcol : StatRuleTableMap::translateFieldName('BanUri', TableMap::TYPE_PHPNAME, $indexType)];
            $this->ban_uri = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 11 + $startcol : StatRuleTableMap::translateFieldName('BanPeriod', TableMap::TYPE_PHPNAME, $indexType)];
            $this->ban_period = (null !== $col) ? (int) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 12; // 12 = StatRuleTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Diamond\\Infrastructure\\Models\\StatRule\\StatRule'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function ensureConsistency(): void
    {
    }

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param bool $deep (optional) Whether to also de-associated any related objects.
     * @param ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload(bool $deep = false, ?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(StatRuleTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildStatRuleQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param ConnectionInterface $con
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     * @see StatRule::setDeleted()
     * @see StatRule::isDeleted()
     */
    public function delete(?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatRuleTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildStatRuleQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    public function save(?ConnectionInterface $con = null): int
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatRuleTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                StatRuleTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con): int
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    }

    /**
     * Insert the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con): void
    {
        $modifiedColumns = [];
        $index = 0;

        $this->modifiedColumns[StatRuleTableMap::COL_ID] = true;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . StatRuleTableMap::COL_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(StatRuleTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_NAME)) {
            $modifiedColumns[':p' . $index++]  = '`name`';
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_CLIENT_TYPE)) {
            $modifiedColumns[':p' . $index++]  = '`client_type`';
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_URI_MASK)) {
            $modifiedColumns[':p' . $index++]  = '`uri_mask`';
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_IP_MASK)) {
            $modifiedColumns[':p' . $index++]  = '`ip_mask`';
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_AGENT_MASK)) {
            $modifiedColumns[':p' . $index++]  = '`agent_mask`';
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_HOST_MASK)) {
            $modifiedColumns[':p' . $index++]  = '`host_mask`';
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_RULE)) {
            $modifiedColumns[':p' . $index++]  = '`rule`';
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_PERIOD)) {
            $modifiedColumns[':p' . $index++]  = '`period`';
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_BAN_RATE)) {
            $modifiedColumns[':p' . $index++]  = '`ban_rate`';
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_BAN_URI)) {
            $modifiedColumns[':p' . $index++]  = '`ban_uri`';
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_BAN_PERIOD)) {
            $modifiedColumns[':p' . $index++]  = '`ban_period`';
        }

        $sql = sprintf(
            'INSERT INTO `_stat_rules` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`name`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`client_type`':
                        $stmt->bindValue($identifier, $this->client_type, PDO::PARAM_STR);
                        break;
                    case '`uri_mask`':
                        $stmt->bindValue($identifier, $this->uri_mask, PDO::PARAM_STR);
                        break;
                    case '`ip_mask`':
                        $stmt->bindValue($identifier, $this->ip_mask, PDO::PARAM_STR);
                        break;
                    case '`agent_mask`':
                        $stmt->bindValue($identifier, $this->agent_mask, PDO::PARAM_STR);
                        break;
                    case '`host_mask`':
                        $stmt->bindValue($identifier, $this->host_mask, PDO::PARAM_STR);
                        break;
                    case '`rule`':
                        $stmt->bindValue($identifier, $this->rule, PDO::PARAM_STR);
                        break;
                    case '`period`':
                        $stmt->bindValue($identifier, $this->period, PDO::PARAM_INT);
                        break;
                    case '`ban_rate`':
                        $stmt->bindValue($identifier, $this->ban_rate, PDO::PARAM_INT);
                        break;
                    case '`ban_uri`':
                        $stmt->bindValue($identifier, $this->ban_uri, PDO::PARAM_STR);
                        break;
                    case '`ban_period`':
                        $stmt->bindValue($identifier, $this->ban_period, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @return int Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con): int
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName(string $name, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = StatRuleTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos Position in XML schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition(int $pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();

            case 1:
                return $this->getName();

            case 2:
                return $this->getClientType();

            case 3:
                return $this->getUriMask();

            case 4:
                return $this->getIpMask();

            case 5:
                return $this->getAgentMask();

            case 6:
                return $this->getHostMask();

            case 7:
                return $this->getRule();

            case 8:
                return $this->getPeriod();

            case 9:
                return $this->getBanRate();

            case 10:
                return $this->getBanUri();

            case 11:
                return $this->getBanPeriod();

            default:
                return null;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param array $alreadyDumpedObjects List of objects to skip to avoid recursion
     *
     * @return array An associative array containing the field names (as keys) and field values
     */
    public function toArray(string $keyType = TableMap::TYPE_PHPNAME, bool $includeLazyLoadColumns = true, array $alreadyDumpedObjects = []): array
    {
        if (isset($alreadyDumpedObjects['StatRule'][$this->hashCode()])) {
            return ['*RECURSION*'];
        }
        $alreadyDumpedObjects['StatRule'][$this->hashCode()] = true;
        $keys = StatRuleTableMap::getFieldNames($keyType);
        $result = [
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getClientType(),
            $keys[3] => $this->getUriMask(),
            $keys[4] => $this->getIpMask(),
            $keys[5] => $this->getAgentMask(),
            $keys[6] => $this->getHostMask(),
            $keys[7] => $this->getRule(),
            $keys[8] => $this->getPeriod(),
            $keys[9] => $this->getBanRate(),
            $keys[10] => $this->getBanUri(),
            $keys[11] => $this->getBanPeriod(),
        ];
        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }


        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this
     */
    public function setByName(string $name, $value, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = StatRuleTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        $this->setByPosition($pos, $value);

        return $this;
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return $this
     */
    public function setByPosition(int $pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setClientType($value);
                break;
            case 3:
                $this->setUriMask($value);
                break;
            case 4:
                $this->setIpMask($value);
                break;
            case 5:
                $this->setAgentMask($value);
                break;
            case 6:
                $this->setHostMask($value);
                break;
            case 7:
                $this->setRule($value);
                break;
            case 8:
                $this->setPeriod($value);
                break;
            case 9:
                $this->setBanRate($value);
                break;
            case 10:
                $this->setBanUri($value);
                break;
            case 11:
                $this->setBanPeriod($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param array $arr An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return $this
     */
    public function fromArray(array $arr, string $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = StatRuleTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setName($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setClientType($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setUriMask($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setIpMask($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setAgentMask($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setHostMask($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setRule($arr[$keys[7]]);
        }
        if (array_key_exists($keys[8], $arr)) {
            $this->setPeriod($arr[$keys[8]]);
        }
        if (array_key_exists($keys[9], $arr)) {
            $this->setBanRate($arr[$keys[9]]);
        }
        if (array_key_exists($keys[10], $arr)) {
            $this->setBanUri($arr[$keys[10]]);
        }
        if (array_key_exists($keys[11], $arr)) {
            $this->setBanPeriod($arr[$keys[11]]);
        }

        return $this;
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this The current object, for fluid interface
     */
    public function importFrom($parser, string $data, string $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria(): Criteria
    {
        $criteria = new Criteria(StatRuleTableMap::DATABASE_NAME);

        if ($this->isColumnModified(StatRuleTableMap::COL_ID)) {
            $criteria->add(StatRuleTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_NAME)) {
            $criteria->add(StatRuleTableMap::COL_NAME, $this->name);
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_CLIENT_TYPE)) {
            $criteria->add(StatRuleTableMap::COL_CLIENT_TYPE, $this->client_type);
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_URI_MASK)) {
            $criteria->add(StatRuleTableMap::COL_URI_MASK, $this->uri_mask);
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_IP_MASK)) {
            $criteria->add(StatRuleTableMap::COL_IP_MASK, $this->ip_mask);
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_AGENT_MASK)) {
            $criteria->add(StatRuleTableMap::COL_AGENT_MASK, $this->agent_mask);
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_HOST_MASK)) {
            $criteria->add(StatRuleTableMap::COL_HOST_MASK, $this->host_mask);
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_RULE)) {
            $criteria->add(StatRuleTableMap::COL_RULE, $this->rule);
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_PERIOD)) {
            $criteria->add(StatRuleTableMap::COL_PERIOD, $this->period);
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_BAN_RATE)) {
            $criteria->add(StatRuleTableMap::COL_BAN_RATE, $this->ban_rate);
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_BAN_URI)) {
            $criteria->add(StatRuleTableMap::COL_BAN_URI, $this->ban_uri);
        }
        if ($this->isColumnModified(StatRuleTableMap::COL_BAN_PERIOD)) {
            $criteria->add(StatRuleTableMap::COL_BAN_PERIOD, $this->ban_period);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria(): Criteria
    {
        $criteria = ChildStatRuleQuery::create();
        $criteria->add(StatRuleTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int|string Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param int|null $key Primary key.
     * @return void
     */
    public function setPrimaryKey(?int $key = null): void
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     *
     * @return bool
     */
    public function isPrimaryKeyNull(): bool
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of \Diamond\Infrastructure\Models\StatRule\StatRule (or compatible) type.
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param bool $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function copyInto(object $copyObj, bool $deepCopy = false, bool $makeNew = true): void
    {
        $copyObj->setName($this->getName());
        $copyObj->setClientType($this->getClientType());
        $copyObj->setUriMask($this->getUriMask());
        $copyObj->setIpMask($this->getIpMask());
        $copyObj->setAgentMask($this->getAgentMask());
        $copyObj->setHostMask($this->getHostMask());
        $copyObj->setRule($this->getRule());
        $copyObj->setPeriod($this->getPeriod());
        $copyObj->setBanRate($this->getBanRate());
        $copyObj->setBanUri($this->getBanUri());
        $copyObj->setBanPeriod($this->getBanPeriod());
        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Diamond\Infrastructure\Models\StatRule\StatRule Clone of current object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function copy(bool $deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     *
     * @return $this
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->client_type = null;
        $this->uri_mask = null;
        $this->ip_mask = null;
        $this->agent_mask = null;
        $this->host_mask = null;
        $this->rule = null;
        $this->period = null;
        $this->ban_rate = null;
        $this->ban_uri = null;
        $this->ban_period = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);

        return $this;
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param bool $deep Whether to also clear the references on all referrer objects.
     * @return $this
     */
    public function clearAllReferences(bool $deep = false)
    {
        if ($deep) {
        } // if ($deep)

        return $this;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(StatRuleTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preSave(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postSave(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before inserting to database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preInsert(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postInsert(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before updating the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preUpdate(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postUpdate(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before deleting the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preDelete(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postDelete(?ConnectionInterface $con = null): void
    {
            }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);
            $inputData = $params[0];
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->importFrom($format, $inputData, $keyType);
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = $params[0] ?? true;
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->exportTo($format, $includeLazyLoadColumns, $keyType);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
