<?php

namespace Diamond\Infrastructure\Models\Content\Map;

use Diamond\Infrastructure\Models\Content\Content;
use Diamond\Infrastructure\Models\Content\ContentQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_content' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class ContentTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Diamond.Infrastructure.Models.Content.Map.ContentTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = '_content';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Diamond\\Infrastructure\\Models\\Content\\Content';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Diamond.Infrastructure.Models.Content.Content';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 11;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 11;

    /**
     * the column name for the id field
     */
    public const COL_ID = '_content.id';

    /**
     * the column name for the title field
     */
    public const COL_TITLE = '_content.title';

    /**
     * the column name for the body field
     */
    public const COL_BODY = '_content.body';

    /**
     * the column name for the preview field
     */
    public const COL_PREVIEW = '_content.preview';

    /**
     * the column name for the datecreate field
     */
    public const COL_DATECREATE = '_content.datecreate';

    /**
     * the column name for the dateupdate field
     */
    public const COL_DATEUPDATE = '_content.dateupdate';

    /**
     * the column name for the date field
     */
    public const COL_DATE = '_content.date';

    /**
     * the column name for the active field
     */
    public const COL_ACTIVE = '_content.active';

    /**
     * the column name for the author field
     */
    public const COL_AUTHOR = '_content.author';

    /**
     * the column name for the author_id field
     */
    public const COL_AUTHOR_ID = '_content.author_id';

    /**
     * the column name for the category_id field
     */
    public const COL_CATEGORY_ID = '_content.category_id';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Title', 'Body', 'Preview', 'Datecreate', 'DateUpdate', 'Date', 'Active', 'Author', 'AuthorId', 'CategoryId', ],
        self::TYPE_CAMELNAME     => ['id', 'title', 'body', 'preview', 'datecreate', 'dateUpdate', 'date', 'active', 'author', 'authorId', 'categoryId', ],
        self::TYPE_COLNAME       => [ContentTableMap::COL_ID, ContentTableMap::COL_TITLE, ContentTableMap::COL_BODY, ContentTableMap::COL_PREVIEW, ContentTableMap::COL_DATECREATE, ContentTableMap::COL_DATEUPDATE, ContentTableMap::COL_DATE, ContentTableMap::COL_ACTIVE, ContentTableMap::COL_AUTHOR, ContentTableMap::COL_AUTHOR_ID, ContentTableMap::COL_CATEGORY_ID, ],
        self::TYPE_FIELDNAME     => ['id', 'title', 'body', 'preview', 'datecreate', 'dateupdate', 'date', 'active', 'author', 'author_id', 'category_id', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Title' => 1, 'Body' => 2, 'Preview' => 3, 'Datecreate' => 4, 'DateUpdate' => 5, 'Date' => 6, 'Active' => 7, 'Author' => 8, 'AuthorId' => 9, 'CategoryId' => 10, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'title' => 1, 'body' => 2, 'preview' => 3, 'datecreate' => 4, 'dateUpdate' => 5, 'date' => 6, 'active' => 7, 'author' => 8, 'authorId' => 9, 'categoryId' => 10, ],
        self::TYPE_COLNAME       => [ContentTableMap::COL_ID => 0, ContentTableMap::COL_TITLE => 1, ContentTableMap::COL_BODY => 2, ContentTableMap::COL_PREVIEW => 3, ContentTableMap::COL_DATECREATE => 4, ContentTableMap::COL_DATEUPDATE => 5, ContentTableMap::COL_DATE => 6, ContentTableMap::COL_ACTIVE => 7, ContentTableMap::COL_AUTHOR => 8, ContentTableMap::COL_AUTHOR_ID => 9, ContentTableMap::COL_CATEGORY_ID => 10, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'title' => 1, 'body' => 2, 'preview' => 3, 'datecreate' => 4, 'dateupdate' => 5, 'date' => 6, 'active' => 7, 'author' => 8, 'author_id' => 9, 'category_id' => 10, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'Content.Id' => 'ID',
        'id' => 'ID',
        'content.id' => 'ID',
        'ContentTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        '_content.id' => 'ID',
        'Title' => 'TITLE',
        'Content.Title' => 'TITLE',
        'title' => 'TITLE',
        'content.title' => 'TITLE',
        'ContentTableMap::COL_TITLE' => 'TITLE',
        'COL_TITLE' => 'TITLE',
        '_content.title' => 'TITLE',
        'Body' => 'BODY',
        'Content.Body' => 'BODY',
        'body' => 'BODY',
        'content.body' => 'BODY',
        'ContentTableMap::COL_BODY' => 'BODY',
        'COL_BODY' => 'BODY',
        '_content.body' => 'BODY',
        'Preview' => 'PREVIEW',
        'Content.Preview' => 'PREVIEW',
        'preview' => 'PREVIEW',
        'content.preview' => 'PREVIEW',
        'ContentTableMap::COL_PREVIEW' => 'PREVIEW',
        'COL_PREVIEW' => 'PREVIEW',
        '_content.preview' => 'PREVIEW',
        'Datecreate' => 'DATECREATE',
        'Content.Datecreate' => 'DATECREATE',
        'datecreate' => 'DATECREATE',
        'content.datecreate' => 'DATECREATE',
        'ContentTableMap::COL_DATECREATE' => 'DATECREATE',
        'COL_DATECREATE' => 'DATECREATE',
        '_content.datecreate' => 'DATECREATE',
        'DateUpdate' => 'DATEUPDATE',
        'Content.DateUpdate' => 'DATEUPDATE',
        'dateUpdate' => 'DATEUPDATE',
        'content.dateUpdate' => 'DATEUPDATE',
        'ContentTableMap::COL_DATEUPDATE' => 'DATEUPDATE',
        'COL_DATEUPDATE' => 'DATEUPDATE',
        'dateupdate' => 'DATEUPDATE',
        '_content.dateupdate' => 'DATEUPDATE',
        'Date' => 'DATE',
        'Content.Date' => 'DATE',
        'date' => 'DATE',
        'content.date' => 'DATE',
        'ContentTableMap::COL_DATE' => 'DATE',
        'COL_DATE' => 'DATE',
        '_content.date' => 'DATE',
        'Active' => 'ACTIVE',
        'Content.Active' => 'ACTIVE',
        'active' => 'ACTIVE',
        'content.active' => 'ACTIVE',
        'ContentTableMap::COL_ACTIVE' => 'ACTIVE',
        'COL_ACTIVE' => 'ACTIVE',
        '_content.active' => 'ACTIVE',
        'Author' => 'AUTHOR',
        'Content.Author' => 'AUTHOR',
        'author' => 'AUTHOR',
        'content.author' => 'AUTHOR',
        'ContentTableMap::COL_AUTHOR' => 'AUTHOR',
        'COL_AUTHOR' => 'AUTHOR',
        '_content.author' => 'AUTHOR',
        'AuthorId' => 'AUTHOR_ID',
        'Content.AuthorId' => 'AUTHOR_ID',
        'authorId' => 'AUTHOR_ID',
        'content.authorId' => 'AUTHOR_ID',
        'ContentTableMap::COL_AUTHOR_ID' => 'AUTHOR_ID',
        'COL_AUTHOR_ID' => 'AUTHOR_ID',
        'author_id' => 'AUTHOR_ID',
        '_content.author_id' => 'AUTHOR_ID',
        'CategoryId' => 'CATEGORY_ID',
        'Content.CategoryId' => 'CATEGORY_ID',
        'categoryId' => 'CATEGORY_ID',
        'content.categoryId' => 'CATEGORY_ID',
        'ContentTableMap::COL_CATEGORY_ID' => 'CATEGORY_ID',
        'COL_CATEGORY_ID' => 'CATEGORY_ID',
        'category_id' => 'CATEGORY_ID',
        '_content.category_id' => 'CATEGORY_ID',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('_content');
        $this->setPhpName('Content');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Infrastructure\\Models\\Content\\Content');
        $this->setPackage('Diamond.Infrastructure.Models.Content');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('title', 'Title', 'VARCHAR', true, 255, null);
        $this->addColumn('body', 'Body', 'LONGVARCHAR', false, null, null);
        $this->addColumn('preview', 'Preview', 'LONGVARCHAR', false, null, null);
        $this->addColumn('datecreate', 'Datecreate', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('dateupdate', 'DateUpdate', 'TIMESTAMP', false, null, null);
        $this->addColumn('date', 'Date', 'TIMESTAMP', true, null, null);
        $this->addColumn('active', 'Active', 'CHAR', true, null, 'Y');
        $this->addColumn('author', 'Author', 'VARCHAR', false, 255, null);
        $this->addColumn('author_id', 'AuthorId', 'INTEGER', false, null, null);
        $this->addForeignKey('category_id', 'CategoryId', 'INTEGER', '_content_category', 'id', true, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('ContentCategory', '\\Diamond\\Infrastructure\\Models\\ContentCategory\\ContentCategory', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':category_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('ContentTagRel', '\\Diamond\\Infrastructure\\Models\\ContentTagRel\\ContentTagRel', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':content_id',
    1 => ':id',
  ),
), null, null, 'ContentTagRels', false);
        $this->addRelation('ContentTag', '\\Diamond\\Infrastructure\\Models\\ContentTag\\ContentTag', RelationMap::MANY_TO_MANY, array(), null, null, 'ContentTags');
    }

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array<string, array> Associative array (name => parameters) of behaviors
     */
    public function getBehaviors(): array
    {
        return [
            'archivable' => ['archive_table' => '', 'archive_phpname' => NULL, 'archive_class' => '', 'log_archived_at' => 'true', 'archived_at_column' => 'archived_at', 'archive_on_insert' => 'false', 'archive_on_update' => 'false', 'archive_on_delete' => 'true'],
        ];
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? ContentTableMap::CLASS_DEFAULT : ContentTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (Content object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = ContentTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = ContentTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + ContentTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ContentTableMap::OM_CLASS;
            /** @var Content $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            ContentTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = ContentTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = ContentTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Content $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ContentTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ContentTableMap::COL_ID);
            $criteria->addSelectColumn(ContentTableMap::COL_TITLE);
            $criteria->addSelectColumn(ContentTableMap::COL_BODY);
            $criteria->addSelectColumn(ContentTableMap::COL_PREVIEW);
            $criteria->addSelectColumn(ContentTableMap::COL_DATECREATE);
            $criteria->addSelectColumn(ContentTableMap::COL_DATEUPDATE);
            $criteria->addSelectColumn(ContentTableMap::COL_DATE);
            $criteria->addSelectColumn(ContentTableMap::COL_ACTIVE);
            $criteria->addSelectColumn(ContentTableMap::COL_AUTHOR);
            $criteria->addSelectColumn(ContentTableMap::COL_AUTHOR_ID);
            $criteria->addSelectColumn(ContentTableMap::COL_CATEGORY_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.title');
            $criteria->addSelectColumn($alias . '.body');
            $criteria->addSelectColumn($alias . '.preview');
            $criteria->addSelectColumn($alias . '.datecreate');
            $criteria->addSelectColumn($alias . '.dateupdate');
            $criteria->addSelectColumn($alias . '.date');
            $criteria->addSelectColumn($alias . '.active');
            $criteria->addSelectColumn($alias . '.author');
            $criteria->addSelectColumn($alias . '.author_id');
            $criteria->addSelectColumn($alias . '.category_id');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(ContentTableMap::COL_ID);
            $criteria->removeSelectColumn(ContentTableMap::COL_TITLE);
            $criteria->removeSelectColumn(ContentTableMap::COL_BODY);
            $criteria->removeSelectColumn(ContentTableMap::COL_PREVIEW);
            $criteria->removeSelectColumn(ContentTableMap::COL_DATECREATE);
            $criteria->removeSelectColumn(ContentTableMap::COL_DATEUPDATE);
            $criteria->removeSelectColumn(ContentTableMap::COL_DATE);
            $criteria->removeSelectColumn(ContentTableMap::COL_ACTIVE);
            $criteria->removeSelectColumn(ContentTableMap::COL_AUTHOR);
            $criteria->removeSelectColumn(ContentTableMap::COL_AUTHOR_ID);
            $criteria->removeSelectColumn(ContentTableMap::COL_CATEGORY_ID);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.title');
            $criteria->removeSelectColumn($alias . '.body');
            $criteria->removeSelectColumn($alias . '.preview');
            $criteria->removeSelectColumn($alias . '.datecreate');
            $criteria->removeSelectColumn($alias . '.dateupdate');
            $criteria->removeSelectColumn($alias . '.date');
            $criteria->removeSelectColumn($alias . '.active');
            $criteria->removeSelectColumn($alias . '.author');
            $criteria->removeSelectColumn($alias . '.author_id');
            $criteria->removeSelectColumn($alias . '.category_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(ContentTableMap::DATABASE_NAME)->getTable(ContentTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a Content or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or Content object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ContentTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Infrastructure\Models\Content\Content) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ContentTableMap::DATABASE_NAME);
            $criteria->add(ContentTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = ContentQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            ContentTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                ContentTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _content table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return ContentQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Content or Criteria object.
     *
     * @param mixed $criteria Criteria or Content object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ContentTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Content object
        }

        if ($criteria->containsKey(ContentTableMap::COL_ID) && $criteria->keyContainsValue(ContentTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.ContentTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = ContentQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
