<?php

namespace Diamond\Domain\PromoBlock\Contracts;

use Diamond\Domain\Site\Contracts\SiteFilterInterface;
use Diamond\Repositories\PromoBlock\PromoBlockCriteria;
use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;

interface PromoBlockCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface, SiteFilterInterface
{

    public function getSearchByCode(): ?string;

    public function getSearchByTitle(): ?string;

    public function getFilterByCode(): ?string;


    public function getSearchByUrlMask(): ?string;

    public function setSearchByUrlMask(?string $searchByUrlMask): PromoBlockCriteriaInterface;

    /**
     * @return string|null
     */
    public function getFilterByUrlMask(): ?string;

    /**
     * @param string|null $filterByUrlMask
     * @return PromoBlockCriteria
     */
    public function setFilterByUrlMask(?string $filterByUrlMask): PromoBlockCriteriaInterface;
}