<?php


namespace Diamond\Application\Notification\SendSms;


use Diamond\Application\Notification\Dto\Message;

/**
 * Class SendSmsCommand
 * @package Diamond\Application\Notification\SendSms
 */
class SendSmsCommand
{

    protected $phone;

    protected $message;

    /**
     * SendSmsCommand constructor.
     * @param string $phone
     * @param Message $message
     */
    public function __construct(string $phone, Message $message)
    {
        $this->phone = $phone;
        $this->message = $message;
    }

    /**
     * @return string
     */
    public function getPhone(): string
    {
        return $this->phone;
    }

    /**
     * @return Message
     */
    public function getMessage(): Message
    {
        return $this->message;
    }


}