<?php

namespace ExportEngine\Drivers;

use ExportEngine\Contracts\ExportDriverInterface;

/**
 * Html export driver
 */
class JsonDriver extends Xml
{
    protected $ext = 'json';

    protected $lastRow = null;

    /**
     * @param string $fileName
     */
    public function output(string $fileName): void
    {
        header("Content-type: application/vnd.ms-excel");
        header("Content-Type: application/force-download");
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . $fileName . '"');

        $this->outputOnlyData();
    }

    /**
     * @return string
     */
    protected function outputOnlyData(): void
    {
        echo $this->getFirstLine();

        foreach ($this->readTransport->read() as $row) {
            echo $this->prepareRow($row);
        }

        echo $this->getLastLine();
    }


    /**
     * @param string $path
     * @throws ExportException
     */
    public function exportToFile(string $path): void
    {


        if (!$outputHandle = fopen($path, 'w+')) {
            throw new ExportException('Unable to open file to write!');
        }

        $data = [];

        foreach ($this->readTransport->read() as $row) {
            $rowInsert = [];
            foreach ($row as $field => $value) {
                $rowInsert[$field] = $this->prepareValue((string)$value);
            }
            $data[] = $rowInsert;
        }
        fwrite($outputHandle, json_encode($data, JSON_UNESCAPED_UNICODE));

        fflush($outputHandle);

        fclose($outputHandle);
    }
}
