<?php

namespace ExportEngine\Drivers;

class XmlDrom extends Xml2
{
    protected static $mapData = [
//        'prd_name' => 'manufacturer',
//        'comment' => 'name',
        'article' => 'oem_number',
        'remain' => 'quantity',
        'analogs' => 'analog_numbers',
        'brand' => 'manufacturer',
        'product_name' => 'name',
        'spare_info' => 'name',
        'availability' => 'available',
        'currency' => 'currencyId'
    ];

    protected function prepareRow(array $row): string
    {
        $row['available'] = $row['remain'] > 0 ? 'true' : 'false';
         if(!empty($row['analogs'])){
             $newAnalos = [];
             if(strpos($row['analogs'], '|') !== false || strpos($row['analogs'], ':')){
               $ar = explode('|', $row['analogs']);
               foreach ($ar as $el){
                   if(preg_match('~^(.*?)\:(.*?)$~',$el,$match)){
                       $newAnalos[]=$match[2];
                   }

               }
             }

             $row['analogs'] = implode(',',$newAnalos);
         }

        return parent::prepareRow($row);
    }
}