<?php
namespace ExportEngine\Drivers;

/**
 *  Xml export driver
 */
class Xml2 extends Xml
{

    protected static $mapData = [
        'prd_name' => 'manufacturer',
        'comment' => 'name',
        'code' => 'oem_number',

    ];

    protected static $mapCache = [];

    /**
     * @return string
     */
    protected function getFirstLine(): string
    {
        $res = '<?xml version="1.0" encoding="UTF-8"?>' . PHP_EOL;
        $res .= '<offers>' . PHP_EOL;
        return $res;
    }

    /**
     * @return string
     */
    protected function getLastLine(): string
    {
        return '</offers>';
    }

    /**
     * обработка строки массива
     * @param array $row
     * @return string
     */
    protected function prepareRow(array $row): string
    {
        $head = $this->getStructureData($row);

        $res = '<offer>' . PHP_EOL;
        foreach ($row as $item) {
            $name = current($head);
            if (!$name) {
                continue;
            }
            $res .= '<' . $name . '>' . $this->prepareValue((string)$item) . '</' . $name . '>' . PHP_EOL;
            next($head);
        }

        return $res . '</offer>' . PHP_EOL;
    }


    /**
     * массив который будет использоваться л=для структуры строки
     * @param array $row
     * @return array
     */
    private function getStructureData(array $row): array
    {

        if (count(static::$mapCache)) {
            return static::$mapCache;
        }

        $map = array_keys($row);

        foreach (static::$mapData as $k => $v) {
            $key = array_search($k, $map);
            if ($key !== false) {
                $map[$key] = $v;
            }
        }

        static::$mapCache = $map;

        return static::$mapCache;


        if (count(static::$mapCache)) {
            return static::$mapCache;
        }

        $map = $row;

        foreach (static::$mapData as $k => $v) {
            $key = array_search($k, $map);
            if ($key !== false) {
                $map[$key] = $v;
            }
        }

        static::$mapCache = $map;

        return static::$mapCache;
    }
}
