<?php
/**
 * Created by PhpStorm.
 * User: d.lanec
 * Date: 03.08.2020
 * Time: 17:02
 */

namespace ExportEngine\Drivers;


final class SourceData
{

    protected $source;

    /**
     * SourceData constructor.
     *
     * @param $source - файловый ресур
     */
    public function __construct($source)
    {
        $this->source = $source;
    }

    /**
     * сброс указателя , перед началом прохода
     */
    public function clearPointer(): void
    {
        rewind($this->source);
    }

    /**
     * проход по содержимому
     * @return array|null
     */
    public function walk(): ?array
    {
        $line = fgets($this->source, 5000);

        return !$line ? null : unserialize(base64_decode($line));
    }

    /**
     * добавления данных
     * @param array $rows многомерный массив
     */
    public function addData(array $rows): void
    {
        foreach ($rows as $row) {
            fwrite($this->source, base64_encode(serialize($row)) . PHP_EOL);
        }
        fflush($this->source);
    }

    /**
     * путь к ресурсу
     * @return string
     */
    public function getSourcePath(): string
    {
        return stream_get_meta_data($this->source)['uri'];
    }

    public function __destruct()
    {
        fclose($this->source);
    }
}