<?php

namespace ExportEngine\Drivers;

use Box\Spout\Common\Exception\IOException;
use Box\Spout\Writer\Common\Creator\Style\StyleBuilder;
use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use ExportEngine\Exceptions\ExportException;

/**
 * Class Xlsx
 * @package ExportEngine\Drivers
 */
class Xlsx extends Csv
{
    protected $ext = 'xlsx';

    use FileNameTrait;

    /**
     * @param string $path
     * @throws ExportException
     * @throws IOException
     * @throws \Box\Spout\Writer\Exception\InvalidSheetNameException
     * @throws \Box\Spout\Writer\Exception\WriterNotOpenedException
     */
    public function exportToFile(string $path): void
    {
        // exit('------------->');
        //libxml_disable_entity_loader(false);

        $ext = $this->getExtension();
        $writer = WriterEntityFactory::createXLSXWriter();

        try {
            $writer->openToFile($path);
        } catch (IOException $e) {
            throw new ExportException('Unable to open file to write! error: ' . $e->getMessage());
        }
        $writer->getCurrentSheet()->setName($this->createScheetName($path));

        $writer->addRow(WriterEntityFactory::createRowFromArray($this->head));

        // Создаем стиль для чисел с двумя знаками после запятой
        $style = (new StyleBuilder())
            ->setFormat('0.000')
            ->build();

        foreach ($this->readTransport->read() as $row) {
            $cells = [];
            foreach ($row as $id => $value) {
                //$row[$id] = $this->prepareValue((string)$value);
                $cells[] = WriterEntityFactory::createCell($value, $style);
            }
            $rowFormat = WriterEntityFactory::createRow($cells);
            $writer->addRow($rowFormat);
            //dd($rowFormat);

            //$writer->addRow(WriterEntityFactory::createRowFromArray($row));
        }

        $this->readTransport->close();

        $writer->close();
    }
}
