<?php

namespace ExportEngine\Service\Serialize;

use Generator;

class ReadTransport
{
    protected $handle;

    /**
     * @param string $filePath
     */
    public function __construct($filePath)
    {
        $this->handle = fopen($filePath, 'rb');
    }

    /**
     * @return Generator|null
     */
    public function read(): ?Generator
    {
        while (false !== ($buffer = fgets($this->handle))) {
            yield DataTransformer::unpack($buffer);
        }
    }

    public function close(): void
    {
        if (gettype($this->handle) === 'resource') {
            fclose($this->handle);
        }
    }

    public function rewind(): void
    {
        rewind($this->handle);
    }
}
