<?php

namespace ExportEngine\Drivers;


use phpDocumentor\Reflection\Types\Self_;

class XmlDrom extends Xml2
{
    protected const TAG_AVALIABLE = 'available';

    public const IMG_DELIMITER = '|';

    protected static $mapData = [
//        'prd_name' => 'manufacturer',
//        'comment' => 'name',
        'article' => 'oem_number',
        'remain' => 'quantity',
        'analogs' => 'analog_numbers',
        'brand' => 'manufacturer',
        'product_name' => 'name',
        'spare_info' => 'name',
        'availability' => self::TAG_AVALIABLE,
        'currency' => 'currencyId'
    ];

    protected function prepareRow(array $row): string
    {

        $row['available'] = $row['remain'] > 0 ? 'true' : 'false';


         if(!empty($row['analogs'])){
             $newAnalos = [];
             if(strpos($row['analogs'], '|') !== false || strpos($row['analogs'], ':')){
               $ar = explode('|', $row['analogs']);
               foreach ($ar as $el){
                   if(preg_match('~^(.*?)\:(.*?)$~',$el,$match)){
                       $newAnalos[]=$match[2];
                   }

               }
             }

             $row['analogs'] = implode(',',$newAnalos);
         }

         if(!empty($row['images'])){
             $images = explode(self::IMG_DELIMITER,$row['images']);
             $row['picture'] = $images;
             unset($row['images']);
         }

        $head = $this->getStructureData($row);

        $tags ='type="product"';

        if(!empty($row[self::TAG_AVALIABLE])){
            $tags.=' available="'.$row[self::TAG_AVALIABLE].'"';
        }

        $res = sprintf('<offer %s>',$tags) . PHP_EOL;
        foreach ($row as $item) {
            $name = current($head);
            if (!$name) {
                continue;
            }
            if(is_array($item)) {
                foreach ($item as $itemValue) {
                    $res .= '<' . $name . '>' . $this->prepareValue((string)$itemValue) . '</' . $name . '>' . PHP_EOL;
                }
            }
            else{
                $res .= '<' . $name . '>' . $this->prepareValue((string)$item) . '</' . $name . '>' . PHP_EOL;
            }

            next($head);
        }

        return $res . '</offer>' . PHP_EOL;
    }


}