<?php

namespace ExportEngine\Drivers;

use PartScanner\Presentation\Helpers\ImageHelper;

class XmlAvito extends Xml2
{
    //protected const TAG_AVALIABLE = 'available';

    protected static $mapData = [
        'weight' =>  'WeightForDelivery',
        'depth' =>  'LengthForDelivery',
        'width' =>  'WidthForDelivery',
        'height' =>  'HeightForDelivery',
        'brand'  =>  'Brand',
        'article' => 'Oem',
        'spare_info' => 'Title',
        'price' => 'Price',
        'description' => 'Description',
        'category' => 'Category',
        'catalog' => 'GoodsType'
    ];

    protected function getFirstLine(): string
    {
        return '<Ads formatVersion="3" target="Avito.ru">';
    }

    protected function getLastLine(): string
    {
        return '</Ads>';
    }


    protected function prepareRow(array $row): string
    {


         if(!empty($row['analogs'])){
             $newAnalos = [];
             if(strpos($row['analogs'], '|') !== false || strpos($row['analogs'], ':')){
               $ar = explode('|', $row['analogs']);
               foreach ($ar as $el){
                   if(preg_match('~^(.*?)\:(.*?)$~',$el,$match)){
                       $newAnalos[]=$match[2];
                   }

               }
             }

             $row['analogs'] = implode(',',$newAnalos);
         }

         if(!empty($row['images'])){

             $images = explode(ImageHelper::IMG_DELIMITER,$row['images']);

             unset($row['images']);
             $row['Images'] = $images;

         }

        $head = $this->getStructureData($row);

        $tags ='type="product"';

//        if(!empty($row[self::TAG_AVALIABLE])){
//            $tags.=' available="'.$row[self::TAG_AVALIABLE].'"';
//        }

        if(!empty($row['remain']) && $row['remain'] > 0){
            $row['Availability'] = 'В наличии';
        }
        else{
            $row['Availability'] = 'Под заказ';
        }


        $res = '<Ad>' . PHP_EOL;
        foreach ($row as $item) {
            $name = current($head);
            if (!$name) {
                continue;
            }
            if(is_array($item)) {
                $res .= '<' . $name . '>';
                foreach ($item as $itemValue) {
                    if($name==='Images'){
                        $res .=  '<Image url="'.$itemValue.'"/>' . PHP_EOL;
                    }
                    else{
                        $res .=  $this->prepareValue((string)$itemValue)  . PHP_EOL;
                    }
                }
                $res .= '</' . $name . '>';
            }
            else{
                $res .= '<' . $name . '>' . $this->prepareValue((string)$item) . '</' . $name . '>' . PHP_EOL;
            }

            next($head);
        }

        $res .= '</Ad>' . PHP_EOL;

            dd(
                $res
            );

        return $res;
    }


}