<?php

namespace ExportEngine\Drivers;

use ExportEngine\Contracts\ExportDriverInterface;

/**
 * Html export driver
 */
class JsonlDriver extends Xml
{
    protected $ext = 'jsonl';

    protected $lastRow = null;

    /**
     * @param string $fileName
     */
    public function output(string $fileName): void
    {
        header("Content-type: application/vnd.ms-excel");
        header("Content-Type: application/force-download");
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . $fileName . '"');

        $this->outputOnlyData();
    }

    /**
     * @return string
     */
    protected function outputOnlyData(): void
    {
        echo $this->getFirstLine();

        foreach ($this->readTransport->read() as $row) {
            echo $this->prepareRow($row);
        }

        echo $this->getLastLine();
    }


    /**
     * @param string $path
     * @throws ExportException
     */
    public function exportToFile(string $path): void
    {


        if (!$outputHandle = fopen($path, 'w+')) {
            throw new ExportException('Unable to open file to write!');
        }

        $data = [];
        $i = 0;

        foreach ($this->readTransport->read() as $row) {
            $rowInsert = [];
            foreach ($row as $field => $value) {
                $rowInsert[$field] = $this->prepareValue((string)$value);
            }

            if ($i === 0) {
                fwrite($outputHandle, json_encode(array_keys($rowInsert),JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES) . PHP_EOL);
            }

            fwrite($outputHandle, json_encode(array_values($rowInsert),JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES) . PHP_EOL);

            $i++;
        }

        fflush($outputHandle);

        fclose($outputHandle);
    }
}
