<?php

require __DIR__ . '/../vendor/autoload.php';


$extFile = 'yml';
$driver = new \ExportEngine\Drivers\YandexMarket();

$exporter = new \ExportEngine\Exporter($driver);

$driver->setOrganizationName("Организация")
    ->setOrganizationFullName('Полное название организации')
    ->setCurrencyList(['RUR' => 1])
    ->setSiteUrl('site.local')
    ->setDeliveryCost(100)
    ->setDeliveryDays(5)
    ->setDeliveryOrderBefore(17);

$count = 10;

for ($i = 0; $i<$count; $i++) {
    $exporter->addRow([
        'producerName' => 'brand-' . $i,
        'code' => 'article-' . $i,
        'price' => '10',
        'name' => 'наименование №' . $i,
        'image' => '/_upload/10.png',
        'categoryLine' => 'cat1' . $i . '|cat2' . $i . '|cat3' . $i,
        'description' => 'описание товара #' . $i,
        'otherData' => [
            'url' => '/',
            'propertyList' => [
                'вес' => 10,
                'размер' => 20
            ]
        ]
    ]);
}
$start = microtime(true);
$exporter->exportToFile(__DIR__ . '/cache/file3.' . $extFile);
$finish = microtime(true);
$delta = $finish - $start;
echo $delta . ' сек., mem: ' . round(memory_get_usage() / 1024 / 1024, 2);