<?php

namespace ExportEngine\Exceptions;

/**
 * Description of FileFormatNotSupportedException
 *
 * @author d.lanec
 */
class FileFormatNotSupportedException extends BaseException
{
    /**
     * @var string
     */
    private $format;

    /**
     * FormatNotSupported constructor.
     *
     * @param string $format
     */
    public function __construct($format)
    {
        parent::__construct('Format ' . $format . ' of the file is not supported');
        
        $this->format = $format;
    }

    /**
     * @return mixed
     */
    public function getFormat()
    {
        return $this->format;
    }
}
