<?php

namespace ExportEngine\Service\Serialize;

class WriteTransport
{
    protected $handle;

    /**
     * @param string $filePath
     */
    public function __construct($filePath)
    {
        $this->handle = fopen($filePath, 'w+');
    }

    /**
     * @param array $data
     */
    public function write(array $data): void
    {
        fwrite($this->handle, DataTransformer::pack($data) . PHP_EOL);
    }

    public function close(): void
    {
        if (gettype($this->handle) === 'resource') {
            fclose($this->handle);
        }
    }
}
