<?php

namespace ExportEngine\Drivers;

use ExportEngine\Contracts\ExportDriverInterface;
use Spreadsheet_Excel_Writer;

/**
 * Xls export driver
 */
class Xls extends AbstractDriver implements ExportDriverInterface
{
    protected $ext = 'xls';

    use FileNameTrait;

    /**
     * @param $sheet
     */
    protected function outputOnlyData($sheet): void
    {
        mb_internal_encoding('latin1');

        $row = $col = 0;

        if (count($this->head)) {
            $sheet->writeRow($row, $col, $this->head);
        }

        $row = 1;
        foreach ($this->readTransport->read() as $data) {
            foreach ($data as $id => $value) {
                $data[$id] = $this->prepareValue($value);
            }
            $sheet->writeRow($row, 0, $data);
            $row++;
        }
    }

    /**
     * @param string $fileName
     */
    public function output(string $fileName): void
    {
        $writer = new Spreadsheet_Excel_Writer();
        $writer->setVersion(8);

        $writer->send($this->createScheetName($fileName));
        $sheet = $writer->addWorksheet($this->createScheetName($fileName));
        $sheet->setInputEncoding('UTF-8');

        $this->outputOnlyData($sheet);

        $writer->close();
    }

    /**
     * @param string $path
     */
    public function exportToFile(string $path): void
    {
        $writer = new Spreadsheet_Excel_Writer($path);
        $writer->setVersion(8);

        $sheet = $writer->addWorksheet($this->createScheetName($path));
        $sheet->setInputEncoding('UTF-8');

        $this->outputOnlyData($sheet);

        $writer->close();
    }
}
