<?php

namespace ExportEngine\Drivers;

use ExportEngine\Contracts\ExportDriverInterface;

/**
 * Html export driver
 */
class Html extends Xml
{
    protected $ext = 'html';

    /**
     * @param string $fileName
     */
    public function output(string $fileName): void
    {
        header('Content-type: text/html');
        header('Content-Disposition: attachment; filename="' . $fileName . '"');

        $this->outputOnlyData();
    }

    /**
     * @return string
     */
    protected function getFirstLine(): string
    {
        $res = '<table class="table-csv-data">' . PHP_EOL;
        $res .= '<tbody>' . PHP_EOL;
        $res .= $this->prepareRow($this->head);
        return $res;
    }

    /**
     * @return string
     */
    protected function getLastLine(): string
    {
        return '</tbody>' . PHP_EOL . '</table>';
    }

    /**
     * обработка строки массива
     * @param array $row
     * @return string
     */
    protected function prepareRow(array $row): string
    {
        $res = '<tr>' . PHP_EOL;
        foreach ($row as $item) {
            $res .= '<td>' . $this->prepareValue($item) . '</td>' . PHP_EOL;
        }
        return $res . '</tr>' . PHP_EOL;
    }
}
