<?php

namespace benchmark;

use ExportEngine\Exporter;
use ExportEngine\Factories\DriverFactory;

class ExportWrapper
{
    protected $fileDir = '';

    public function __construct($fileDir)
    {
        $this->fileDir = $fileDir;
    }

    public function bench($max, $ext)
    {
        $driver = DriverFactory::buildByType($ext);
        $exporter = new Exporter($driver);

        $t = [
            'id', 'name', 'email', 'code', 'address'
        ];
        $exporter->setHeader($t);

        for ($i = 0; $i < $max; $i++) {
            $t = [
                'id' => $i,
                'name' => 'Вася Питериский',
                'email' => 'vacia@mail.ru',
                'password' => md5($i),
                'address' => 'Адрес: г. Киров обл., 610998, ул.Комсомольская, 34 '
            ];
            $exporter->addRow($t);
        }

        $filePath = $this->fileDir . 'out_' . $max . '_' . $ext . '.' . $ext;

        $exporter->exportToFile($filePath);
    }
}
