<?php

namespace benchmark;

class Benchmark
{
    public function start($count, $ext)
    {
        $benchArr = [
            '10000' => [
                'csv',
                'txt',
                'xml',
                'xml2',
                'xls',
                'xlsx',
            ],
            '65534' => [
                'csv',
                'txt',
                'xml',
                'xml2',
                'xls',
                'xlsx',
            ],
            '1000000' => [
                'csv',
                'txt',
                'xml',
                'xml2',
                'xls',
                'xlsx',
            ]
        ];

        $fileDir =  __DIR__ . '/output/';

        $obj = new ExportWrapper($fileDir);

        $useBench[$count][$ext] = 1;

        $useBenchArr = [];
        foreach ($benchArr as $max => $extArr) {
            if (isset($useBench[$max])) {
                foreach ($extArr as $e) {
                    if (isset($useBench[$max][$e])) {
                        $useBenchArr[$max][] = $e;
                    }
                }
            }
        }

        foreach ($useBenchArr as $max => $extArr) {
            foreach ($extArr as $e) {
                $start = microtime(true);
                $obj->bench($max, $e);
                $finish = microtime(true);
                $delta = number_format($finish - $start, 1);
                echo $max . ' :: ' . $e . ' :: ' . $delta . ' сек., mem_peak: ' .
                    round(memory_get_peak_usage(true) / 1024 / 1024, 2);
            }
        }
    }
}
